/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.content.blocks.cogs;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.content.kinetics.base.SingleAxisRotatingVisual;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.api.visual.BlockEntityVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.lopyluna.dndecor.content.blocks.cogs.DnDCogWheelBlock;
import dev.lopyluna.dndecor.register.client.DnDecorPartialModels;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;

public class DnDCogwheelVisual {
    public static BlockEntityVisual<BracketedKineticBlockEntity> create(VisualizationContext context, BracketedKineticBlockEntity be, float partialTick) {
        if (ICogWheel.isLargeCog((BlockState)be.getBlockState())) {
            return new LargeCogVisual(context, be, partialTick);
        }
        return new SmallCogVisual(context, be, partialTick);
    }

    public static class LargeCogVisual
    extends SingleAxisRotatingVisual<BracketedKineticBlockEntity> {
        protected final RotatingInstance additionalShaft;

        private LargeCogVisual(VisualizationContext context, BracketedKineticBlockEntity blockEntity, float partialTick) {
            super(context, (KineticBlockEntity)blockEntity, partialTick, LargeCogVisual.getLargeModel(blockEntity));
            Direction.Axis axis = KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)blockEntity);
            this.additionalShaft = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)AllPartialModels.COGWHEEL_SHAFT)).createInstance();
            this.additionalShaft.rotateToFace(axis).setup((KineticBlockEntity)blockEntity).setRotationOffset(BracketedKineticBlockEntityRenderer.getShaftAngleOffset((Direction.Axis)axis, (BlockPos)this.pos)).setPosition((Vec3i)this.getVisualPosition()).setChanged();
        }

        public static Model getLargeModel(BracketedKineticBlockEntity be) {
            PartialModel partialModel = DnDecorPartialModels.DYED_LARGE_COGWHEEL.get(((DnDCogWheelBlock)be.getBlockState().getBlock()).color);
            if (((DnDCogWheelBlock)be.getBlockState().getBlock()).customModel != null) {
                partialModel = ((DnDCogWheelBlock)be.getBlockState().getBlock()).customModel;
            }
            return Models.partial((PartialModel)partialModel);
        }

        public void update(float pt) {
            super.update(pt);
            this.additionalShaft.setup((KineticBlockEntity)this.blockEntity).setRotationOffset(BracketedKineticBlockEntityRenderer.getShaftAngleOffset((Direction.Axis)this.rotationAxis(), (BlockPos)this.pos)).setChanged();
        }

        public void updateLight(float partialTick) {
            super.updateLight(partialTick);
            this.relight(new FlatLit[]{this.additionalShaft});
        }

        protected void _delete() {
            super._delete();
            this.additionalShaft.delete();
        }

        public void collectCrumblingInstances(Consumer<Instance> consumer) {
            super.collectCrumblingInstances(consumer);
            consumer.accept((Instance)this.additionalShaft);
        }
    }

    public static class SmallCogVisual
    extends SingleAxisRotatingVisual<BracketedKineticBlockEntity> {
        protected final RotatingInstance additionalShaft;

        private SmallCogVisual(VisualizationContext context, BracketedKineticBlockEntity blockEntity, float partialTick) {
            super(context, (KineticBlockEntity)blockEntity, partialTick, SmallCogVisual.getSmallModel(blockEntity));
            Direction.Axis axis = KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)blockEntity);
            this.additionalShaft = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)AllPartialModels.COGWHEEL_SHAFT)).createInstance();
            this.additionalShaft.rotateToFace(axis).setup((KineticBlockEntity)blockEntity).setRotationOffset(BracketedKineticBlockEntityRenderer.getShaftAngleOffset((Direction.Axis)axis, (BlockPos)this.pos)).setPosition((Vec3i)this.getVisualPosition()).setChanged();
        }

        public static Model getSmallModel(BracketedKineticBlockEntity be) {
            PartialModel partialModel = DnDecorPartialModels.DYED_COGWHEEL.get(((DnDCogWheelBlock)be.getBlockState().getBlock()).color);
            if (((DnDCogWheelBlock)be.getBlockState().getBlock()).customModel != null) {
                partialModel = ((DnDCogWheelBlock)be.getBlockState().getBlock()).customModel;
            }
            return Models.partial((PartialModel)partialModel);
        }

        public void update(float pt) {
            super.update(pt);
            this.additionalShaft.setup((KineticBlockEntity)this.blockEntity).setRotationOffset(BracketedKineticBlockEntityRenderer.getShaftAngleOffset((Direction.Axis)this.rotationAxis(), (BlockPos)this.pos)).setChanged();
        }

        public void updateLight(float partialTick) {
            super.updateLight(partialTick);
            this.relight(new FlatLit[]{this.additionalShaft});
        }

        protected void _delete() {
            super._delete();
            this.additionalShaft.delete();
        }

        public void collectCrumblingInstances(Consumer<Instance> consumer) {
            super.collectCrumblingInstances(consumer);
            consumer.accept((Instance)this.additionalShaft);
        }
    }
}

