/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.content.blocks.full_belt;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltBlock;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltHelper;
import com.simibubi.create.content.kinetics.belt.BeltPart;
import com.simibubi.create.content.kinetics.belt.BeltSlicer;
import com.simibubi.create.content.kinetics.belt.BeltSlope;
import com.simibubi.create.content.kinetics.belt.item.BeltConnectorItem;
import com.simibubi.create.content.kinetics.belt.transport.BeltInventory;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import dev.lopyluna.dndecor.mixins.BeltBlockEntityAccessor;
import dev.lopyluna.dndecor.register.DnDecorBlocks;
import dev.lopyluna.dndecor.register.DnDecorItems;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class FullBeltSlicer {
    public static ItemInteractionResult useWrench(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit, BeltSlicer.Feedback feedBack) {
        BlockPos next;
        boolean towardPositive;
        int hitSegment;
        BeltBlockEntity segmentBE;
        List beltChain;
        BeltBlockEntity controllerBE;
        block31: {
            controllerBE = BeltHelper.getControllerBE((LevelAccessor)world, (BlockPos)pos);
            if (controllerBE == null) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (((Boolean)state.getValue((Property)BeltBlock.CASING)).booleanValue() && hit.getDirection() != Direction.UP) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (state.getValue(BeltBlock.PART) == BeltPart.PULLEY && hit.getDirection().getAxis() != Direction.Axis.Y) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            int beltLength = controllerBE.beltLength;
            if (beltLength == 2) {
                return ItemInteractionResult.FAIL;
            }
            BlockPos beltVector = BlockPos.containing((Position)BeltHelper.getBeltVector((BlockState)state));
            BeltPart part = (BeltPart)state.getValue(BeltBlock.PART);
            beltChain = BeltBlock.getBeltChain((LevelAccessor)world, (BlockPos)controllerBE.getBlockPos());
            boolean creative = player.isCreative();
            if (FullBeltSlicer.hoveringEnd(state, hit)) {
                if (world.isClientSide) {
                    return ItemInteractionResult.SUCCESS;
                }
                for (BlockPos blockPos : beltChain) {
                    BeltBlockEntity belt = BeltHelper.getSegmentBE((LevelAccessor)world, (BlockPos)blockPos);
                    if (belt == null) continue;
                    belt.detachKinetics();
                    belt.invalidateItemHandler();
                    belt.beltLength = 0;
                }
                BeltInventory inventory = ((BeltBlockEntityAccessor)controllerBE).getRawInventory();
                BlockPos next2 = part == BeltPart.END ? pos.subtract((Vec3i)beltVector) : pos.offset((Vec3i)beltVector);
                BlockState replacedState = world.getBlockState(next2);
                BeltBlockEntity segmentBE2 = BeltHelper.getSegmentBE((LevelAccessor)world, (BlockPos)next2);
                KineticBlockEntity.switchToBlockState((Level)world, (BlockPos)next2, (BlockState)ProperWaterloggedBlock.withWater((LevelAccessor)world, (BlockState)((BlockState)state.setValue((Property)BeltBlock.CASING, (Comparable)Boolean.valueOf(segmentBE2 != null && segmentBE2.casing != BeltBlockEntity.CasingType.NONE))), (BlockPos)next2));
                world.setBlock(pos, ProperWaterloggedBlock.withWater((LevelAccessor)world, (BlockState)Blocks.AIR.defaultBlockState(), (BlockPos)pos), 67);
                world.removeBlockEntity(pos);
                world.levelEvent(2001, pos, Block.getId((BlockState)state));
                if (!creative && DnDecorBlocks.BELT.has(replacedState) && replacedState.getValue(BeltBlock.PART) == BeltPart.PULLEY) {
                    player.getInventory().placeItemBackInInventory(AllBlocks.SHAFT.asStack());
                }
                if (part == BeltPart.END && inventory != null) {
                    ArrayList toEject = new ArrayList();
                    for (TransportedItemStack transportedItemStack : inventory.getTransportedItems()) {
                        if (!(transportedItemStack.beltPosition > (float)(beltLength - 1))) continue;
                        toEject.add(transportedItemStack);
                    }
                    toEject.forEach(arg_0 -> ((BeltInventory)inventory).eject(arg_0));
                    toEject.forEach(inventory.getTransportedItems()::remove);
                }
                if (part == BeltPart.START && segmentBE2 != null && inventory != null) {
                    ((BeltBlockEntityAccessor)controllerBE).setRawInventory(null);
                    ((BeltBlockEntityAccessor)segmentBE2).setRawInventory(null);
                    segmentBE2.setController(next2);
                    for (TransportedItemStack transportedItemStack : inventory.getTransportedItems()) {
                        transportedItemStack.beltPosition -= 1.0f;
                        if (transportedItemStack.beltPosition <= 0.0f) {
                            ItemEntity entity = new ItemEntity(world, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.6875f), (double)((float)pos.getZ() + 0.5f), transportedItemStack.stack);
                            entity.setDeltaMovement(Vec3.ZERO);
                            entity.setDefaultPickUpDelay();
                            entity.hurtMarked = true;
                            world.addFreshEntity((Entity)entity);
                            continue;
                        }
                        segmentBE2.getInventory().addItem(transportedItemStack);
                    }
                }
                return ItemInteractionResult.SUCCESS;
            }
            segmentBE = BeltHelper.getSegmentBE((LevelAccessor)world, (BlockPos)pos);
            if (segmentBE == null) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            hitSegment = segmentBE.index;
            Vec3 centerOf = VecHelper.getCenterOf((Vec3i)hit.getBlockPos());
            Vec3 subtract = hit.getLocation().subtract(centerOf);
            towardPositive = subtract.dot(Vec3.atLowerCornerOf((Vec3i)beltVector)) > 0.0;
            BlockPos blockPos = next = !towardPositive ? pos.subtract((Vec3i)beltVector) : pos.offset((Vec3i)beltVector);
            if (hitSegment == 0 || hitSegment == 1 && !towardPositive) {
                return ItemInteractionResult.FAIL;
            }
            if (hitSegment == controllerBE.beltLength - 1 || hitSegment == controllerBE.beltLength - 2 && towardPositive) {
                return ItemInteractionResult.FAIL;
            }
            if (!creative) {
                BlockState other;
                int requiredShafts = 0;
                if (!segmentBE.hasPulley()) {
                    ++requiredShafts;
                }
                if (DnDecorBlocks.BELT.has(other = world.getBlockState(next)) && other.getValue(BeltBlock.PART) == BeltPart.MIDDLE) {
                    ++requiredShafts;
                }
                int amountRetrieved = 0;
                boolean beltFound = false;
                for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                    if (amountRetrieved != requiredShafts || !beltFound) {
                        ItemStack itemstack = player.getInventory().getItem(i);
                        if (itemstack.isEmpty()) continue;
                        int count = itemstack.getCount();
                        if (DnDecorItems.BELT_CONNECTOR.isIn(itemstack)) {
                            if (!world.isClientSide) {
                                itemstack.shrink(1);
                            }
                            beltFound = true;
                            continue;
                        }
                        if (!AllBlocks.SHAFT.isIn(itemstack)) continue;
                        int taken = Math.min(count, requiredShafts - amountRetrieved);
                        if (!world.isClientSide) {
                            if (taken == count) {
                                player.getInventory().setItem(i, ItemStack.EMPTY);
                            } else {
                                itemstack.shrink(taken);
                            }
                        }
                        amountRetrieved += taken;
                        continue;
                    }
                    break block31;
                }
                if (!world.isClientSide) {
                    player.getInventory().placeItemBackInInventory(AllBlocks.SHAFT.asStack(amountRetrieved));
                }
                return ItemInteractionResult.FAIL;
            }
        }
        if (!world.isClientSide) {
            BeltBlockEntity newController;
            for (BlockPos blockPos : beltChain) {
                BeltBlockEntity belt = BeltHelper.getSegmentBE((LevelAccessor)world, (BlockPos)blockPos);
                if (belt == null) continue;
                belt.detachKinetics();
                belt.invalidateItemHandler();
                belt.beltLength = 0;
            }
            BeltInventory inventory = ((BeltBlockEntityAccessor)controllerBE).getRawInventory();
            KineticBlockEntity.switchToBlockState((Level)world, (BlockPos)pos, (BlockState)((BlockState)state.setValue(BeltBlock.PART, (Comparable)(towardPositive ? BeltPart.END : BeltPart.START))));
            KineticBlockEntity.switchToBlockState((Level)world, (BlockPos)next, (BlockState)((BlockState)world.getBlockState(next).setValue(BeltBlock.PART, (Comparable)(towardPositive ? BeltPart.START : BeltPart.END))));
            world.playSound(null, pos, SoundEvents.WOOL_HIT, SoundSource.PLAYERS, 0.5f, 2.3f);
            BeltBlockEntity beltBlockEntity = newController = towardPositive ? BeltHelper.getSegmentBE((LevelAccessor)world, (BlockPos)next) : segmentBE;
            if (newController != null && inventory != null) {
                ((BeltBlockEntityAccessor)newController).setRawInventory(null);
                newController.setController(newController.getBlockPos());
                Iterator iterator = inventory.getTransportedItems().iterator();
                while (iterator.hasNext()) {
                    TransportedItemStack transportedItemStack = (TransportedItemStack)iterator.next();
                    float newPosition = transportedItemStack.beltPosition - (float)hitSegment - (float)(towardPositive ? 1 : 0);
                    if (newPosition <= 0.0f) continue;
                    transportedItemStack.beltPosition = newPosition;
                    iterator.remove();
                    newController.getInventory().addItem(transportedItemStack);
                }
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    public static ItemInteractionResult useConnector(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit, BeltSlicer.Feedback feedBack) {
        block23: {
            BlockState blockState;
            BeltInventory inventory;
            int mergedBeltLength;
            BeltBlockEntity mergedController;
            BlockPos next;
            boolean creative;
            BlockPos beltVector;
            int beltLength;
            BeltBlockEntity controllerBE;
            block24: {
                controllerBE = BeltHelper.getControllerBE((LevelAccessor)world, (BlockPos)pos);
                if (controllerBE == null) {
                    return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                }
                beltLength = controllerBE.beltLength;
                if (beltLength == BeltConnectorItem.maxLength()) {
                    return ItemInteractionResult.FAIL;
                }
                beltVector = BlockPos.containing((Position)BeltHelper.getBeltVector((BlockState)state));
                BeltPart part = (BeltPart)state.getValue(BeltBlock.PART);
                Direction facing = (Direction)state.getValue(BeltBlock.HORIZONTAL_FACING);
                List beltChain = BeltBlock.getBeltChain((LevelAccessor)world, (BlockPos)controllerBE.getBlockPos());
                creative = player.isCreative();
                if (!FullBeltSlicer.hoveringEnd(state, hit)) {
                    return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                }
                next = part == BeltPart.START ? pos.subtract((Vec3i)beltVector) : pos.offset((Vec3i)beltVector);
                mergedController = null;
                mergedBeltLength = 0;
                BlockState nextState = world.getBlockState(next);
                if (!nextState.canBeReplaced()) {
                    if (!DnDecorBlocks.BELT.has(nextState)) {
                        return ItemInteractionResult.FAIL;
                    }
                    if (!FullBeltSlicer.beltStatesCompatible(state, nextState)) {
                        return ItemInteractionResult.FAIL;
                    }
                    mergedController = BeltHelper.getControllerBE((LevelAccessor)world, (BlockPos)next);
                    if (mergedController == null) {
                        return ItemInteractionResult.FAIL;
                    }
                    if (mergedController.beltLength + beltLength > BeltConnectorItem.maxLength()) {
                        return ItemInteractionResult.FAIL;
                    }
                    mergedBeltLength = mergedController.beltLength;
                    if (!world.isClientSide) {
                        boolean flipBelt = facing != nextState.getValue(BeltBlock.HORIZONTAL_FACING);
                        Optional color = controllerBE.color;
                        for (Object blockPos : BeltBlock.getBeltChain((LevelAccessor)world, (BlockPos)mergedController.getBlockPos())) {
                            BeltBlockEntity belt = BeltHelper.getSegmentBE((LevelAccessor)world, (BlockPos)blockPos);
                            if (belt == null) continue;
                            belt.detachKinetics();
                            belt.invalidateItemHandler();
                            belt.beltLength = 0;
                            belt.color = color;
                            if (!flipBelt) continue;
                            world.setBlock((BlockPos)blockPos, FullBeltSlicer.flipBelt(world.getBlockState((BlockPos)blockPos)), 67);
                        }
                        if (flipBelt && ((BeltBlockEntityAccessor)mergedController).getRawInventory() != null) {
                            List transportedItems = ((BeltBlockEntityAccessor)mergedController).getRawInventory().getTransportedItems();
                            for (TransportedItemStack transportedItemStack : transportedItems) {
                                transportedItemStack.beltPosition = (float)mergedBeltLength - transportedItemStack.beltPosition;
                                transportedItemStack.prevBeltPosition = (float)mergedBeltLength - transportedItemStack.prevBeltPosition;
                            }
                        }
                        beltChain = BeltBlock.getBeltChain((LevelAccessor)world, (BlockPos)mergedController.getBlockPos());
                    }
                }
                if (world.isClientSide) break block23;
                for (BlockPos blockPos : beltChain) {
                    BeltBlockEntity belt = BeltHelper.getSegmentBE((LevelAccessor)world, (BlockPos)blockPos);
                    if (belt == null) continue;
                    belt.detachKinetics();
                    belt.invalidateItemHandler();
                    belt.beltLength = 0;
                }
                inventory = ((BeltBlockEntityAccessor)controllerBE).getRawInventory();
                KineticBlockEntity.switchToBlockState((Level)world, (BlockPos)pos, (BlockState)((BlockState)state.setValue(BeltBlock.PART, (Comparable)BeltPart.MIDDLE)));
                if (mergedController != null) break block24;
                world.setBlock(next, ProperWaterloggedBlock.withWater((LevelAccessor)world, (BlockState)((BlockState)state.setValue((Property)BeltBlock.CASING, (Comparable)Boolean.valueOf(false))), (BlockPos)next), 67);
                BeltBlockEntity segmentBE = BeltHelper.getSegmentBE((LevelAccessor)world, (BlockPos)next);
                if (segmentBE != null) {
                    segmentBE.color = controllerBE.color;
                }
                world.playSound(null, pos, SoundEvents.WOOL_PLACE, SoundSource.PLAYERS, 0.5f, 1.0f);
                if (part != BeltPart.START || segmentBE == null || inventory == null) break block23;
                segmentBE.setController(next);
                for (TransportedItemStack transportedItemStack : inventory.getTransportedItems()) {
                    transportedItemStack.beltPosition += 1.0f;
                    segmentBE.getInventory().addItem(transportedItemStack);
                }
                break block23;
            }
            BeltInventory mergedInventory = ((BeltBlockEntityAccessor)mergedController).getRawInventory();
            world.playSound(null, pos, SoundEvents.WOOL_HIT, SoundSource.PLAYERS, 0.5f, 1.3f);
            BeltBlockEntity segmentBE = BeltHelper.getSegmentBE((LevelAccessor)world, (BlockPos)next);
            KineticBlockEntity.switchToBlockState((Level)world, (BlockPos)next, (BlockState)((BlockState)((BlockState)state.setValue((Property)BeltBlock.CASING, (Comparable)Boolean.valueOf(segmentBE != null && segmentBE.casing != BeltBlockEntity.CasingType.NONE))).setValue(BeltBlock.PART, (Comparable)BeltPart.MIDDLE)));
            if (!creative) {
                player.getInventory().placeItemBackInInventory(AllBlocks.SHAFT.asStack(2));
                player.getInventory().placeItemBackInInventory(DnDecorItems.BELT_CONNECTOR.asStack());
            }
            for (BlockPos blockPos : BeltBlock.getBeltChain((LevelAccessor)world, (BlockPos)controllerBE.getBlockPos())) {
                BeltBlockEntity belt = BeltHelper.getSegmentBE((LevelAccessor)world, (BlockPos)blockPos);
                if (belt == null) continue;
                belt.invalidateItemHandler();
            }
            BlockPos search = controllerBE.getBlockPos();
            for (int i = 0; i < 10000 && DnDecorBlocks.BELT.has(blockState = world.getBlockState(search)); ++i) {
                if (blockState.getValue(BeltBlock.PART) != BeltPart.START) {
                    search = search.subtract((Vec3i)beltVector);
                    continue;
                }
                BeltBlockEntity newController = BeltHelper.getSegmentBE((LevelAccessor)world, (BlockPos)search);
                if (newController != controllerBE && inventory != null) {
                    newController.setController(search);
                    ((BeltBlockEntityAccessor)controllerBE).setRawInventory(null);
                    for (TransportedItemStack transportedItemStack : inventory.getTransportedItems()) {
                        transportedItemStack.beltPosition += (float)mergedBeltLength;
                        newController.getInventory().addItem(transportedItemStack);
                    }
                }
                if (newController == mergedController || mergedInventory == null) break;
                newController.setController(search);
                ((BeltBlockEntityAccessor)mergedController).setRawInventory(null);
                for (TransportedItemStack transportedItemStack : mergedInventory.getTransportedItems()) {
                    if (newController == controllerBE) {
                        transportedItemStack.beltPosition += (float)beltLength;
                    }
                    newController.getInventory().addItem(transportedItemStack);
                }
                break;
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    static boolean beltStatesCompatible(BlockState state, BlockState nextState) {
        Direction facing1 = (Direction)state.getValue(BeltBlock.HORIZONTAL_FACING);
        BeltSlope slope1 = (BeltSlope)state.getValue(BeltBlock.SLOPE);
        Direction facing2 = (Direction)nextState.getValue(BeltBlock.HORIZONTAL_FACING);
        BeltSlope slope2 = (BeltSlope)nextState.getValue(BeltBlock.SLOPE);
        return switch (slope1) {
            case BeltSlope.UPWARD -> {
                if (slope2 == BeltSlope.DOWNWARD) {
                    if (facing1 == facing2.getOpposite()) {
                        yield true;
                    }
                    yield false;
                }
                if (slope2 == slope1 && facing1 == facing2) {
                    yield true;
                }
                yield false;
            }
            case BeltSlope.DOWNWARD -> {
                if (slope2 == BeltSlope.UPWARD) {
                    if (facing1 == facing2.getOpposite()) {
                        yield true;
                    }
                    yield false;
                }
                if (slope2 == slope1 && facing1 == facing2) {
                    yield true;
                }
                yield false;
            }
            default -> slope2 == slope1 && facing2.getAxis() == facing1.getAxis();
        };
    }

    static BlockState flipBelt(BlockState state) {
        Direction facing = (Direction)state.getValue(BeltBlock.HORIZONTAL_FACING);
        BeltSlope slope = (BeltSlope)state.getValue(BeltBlock.SLOPE);
        BeltPart part = (BeltPart)state.getValue(BeltBlock.PART);
        if (slope == BeltSlope.UPWARD) {
            state = (BlockState)state.setValue(BeltBlock.SLOPE, (Comparable)BeltSlope.DOWNWARD);
        } else if (slope == BeltSlope.DOWNWARD) {
            state = (BlockState)state.setValue(BeltBlock.SLOPE, (Comparable)BeltSlope.UPWARD);
        }
        if (part == BeltPart.END) {
            state = (BlockState)state.setValue(BeltBlock.PART, (Comparable)BeltPart.START);
        } else if (part == BeltPart.START) {
            state = (BlockState)state.setValue(BeltBlock.PART, (Comparable)BeltPart.END);
        }
        return (BlockState)state.setValue(BeltBlock.HORIZONTAL_FACING, (Comparable)facing.getOpposite());
    }

    static boolean hoveringEnd(BlockState state, BlockHitResult hit) {
        BeltPart part = (BeltPart)state.getValue(BeltBlock.PART);
        if (part == BeltPart.MIDDLE || part == BeltPart.PULLEY) {
            return false;
        }
        Vec3 beltVector = BeltHelper.getBeltVector((BlockState)state);
        Vec3 centerOf = VecHelper.getCenterOf((Vec3i)hit.getBlockPos());
        Vec3 subtract = hit.getLocation().subtract(centerOf);
        return subtract.dot(beltVector) > 0.0 == (part == BeltPart.END);
    }
}

