/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.common.mixins.client;

import com.aizistral.nochatreports.common.NCRCore;
import com.aizistral.nochatreports.common.config.NCRConfig;
import com.aizistral.nochatreports.common.core.EncryptionUtil;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.GuiMessageTag;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={ChatComponent.class})
public class MixinChatComponent {
    @Shadow
    @Final
    private Minecraft minecraft;
    private static final GuiMessageTag.Icon ENCRYPTED_ICON = GuiMessageTag.Icon.valueOf((String)"CHAT_NCR_ENCRYPTED");
    private boolean lastMessageEncrypted;
    private Component lastMessageOriginal;

    @ModifyVariable(method={"addRecentChat"}, at=@At(value="HEAD"), argsOnly=true)
    private String onAddRecentChat(String message) {
        if (NCRConfig.getEncryption().isEnabledAndValid()) {
            return NCRConfig.getEncryption().getLastMessage();
        }
        return message;
    }

    @ModifyVariable(index=-1, method={"addMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;Lnet/minecraft/client/GuiMessageTag;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/ChatComponent;logChatMessage(Lnet/minecraft/client/GuiMessage;)V", ordinal=0, shift=At.Shift.BEFORE))
    private GuiMessage modifyGUIMessage(GuiMessage msg) {
        if (!NCRConfig.getEncryption().isEnabledAndValid()) {
            return msg;
        }
        if (this.minecraft.level == null) {
            NCRCore.LOGGER.warn("Chat message cannot be decrypted since level didn't load in yet!");
            return msg;
        }
        if (NCRConfig.getCommon().enableDebugLog()) {
            NCRCore.LOGGER.info("Adding chat message, structure: " + Component.Serializer.toJson((Component)msg.content(), (HolderLookup.Provider)RegistryAccess.EMPTY));
        }
        Optional<Component> decrypted = EncryptionUtil.tryDecrypt((HolderLookup.Provider)this.minecraft.level.registryAccess(), msg.content());
        decrypted.ifPresentOrElse(component -> {
            this.lastMessageOriginal = EncryptionUtil.recreate((HolderLookup.Provider)this.minecraft.level.registryAccess(), msg.content());
            this.lastMessageEncrypted = true;
        }, () -> {
            this.lastMessageEncrypted = false;
        });
        if (this.lastMessageEncrypted) {
            this.lastMessageEncrypted = false;
            Component decryptedComponent = decrypted.get();
            GuiMessageTag newTag = msg.tag();
            if (NCRConfig.getEncryption().showEncryptionIndicators()) {
                MutableComponent tooltip = Component.empty().append((Component)Component.translatable((String)"tag.nochatreports.encrypted", (Object[])new Object[]{Component.literal((String)NCRConfig.getEncryption().getAlgorithm().getName()).withStyle(ChatFormatting.BOLD)})).append(CommonComponents.NEW_LINE).append((Component)Component.translatable((String)"tag.nochatreports.encrypted_original", (Object[])new Object[]{this.lastMessageOriginal}));
                newTag = new GuiMessageTag(9125575, ENCRYPTED_ICON, (Component)tooltip, "Encrypted");
            }
            return new GuiMessage(msg.addedTime(), decryptedComponent, msg.signature(), newTag);
        }
        return msg;
    }
}

