/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.plushables.block;

import com.khazoda.plushables.block.interaction.InteractionEffectData;
import com.khazoda.plushables.block.tooltip.TooltipData;
import com.khazoda.plushables.block.util.VoxelShapeHelper;
import com.khazoda.plushables.platform.Services;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class BasePlushable
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final BlockBehaviour.Properties defaultSettings = BlockBehaviour.Properties.of().sound(SoundType.WOOL).strength(0.1f).noOcclusion().pushReaction(PushReaction.DESTROY);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty ON_COOLDOWN = BooleanProperty.create((String)"on_cooldown");
    final VoxelShape blockShape = this.useShape();
    final VoxelShape[] blockShapes = VoxelShapeHelper.calculateBlockShapes(this.blockShape);
    protected final InteractionEffectData effectData;
    protected final TooltipData tooltipData;

    public BasePlushable() {
        this(defaultSettings);
    }

    public BasePlushable(BlockBehaviour.Properties settings) {
        this(settings, TooltipData.DEFAULT, InteractionEffectData.DEFAULT);
    }

    public BasePlushable(BlockBehaviour.Properties settings, InteractionEffectData effectData) {
        this(settings, TooltipData.DEFAULT, effectData);
    }

    public BasePlushable(BlockBehaviour.Properties settings, TooltipData tooltipData) {
        this(settings, tooltipData, InteractionEffectData.DEFAULT);
    }

    public BasePlushable(BlockBehaviour.Properties settings, TooltipData tooltipData, InteractionEffectData effectData) {
        super(settings.lightLevel(blockState -> effectData.lightLevel()));
        this.effectData = effectData;
        this.tooltipData = tooltipData;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ON_COOLDOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return (Boolean)state.getValue((Property)ON_COOLDOWN) != false ? InteractionResult.CONSUME : (this.playInteractionEffects(level, state, hitResult, (Entity)player) ? InteractionResult.sidedSuccess((boolean)level.isClientSide) : InteractionResult.PASS);
    }

    public boolean playInteractionEffects(Level level, BlockState state, BlockHitResult hitResult, Entity entity) {
        BlockPos blockPos = hitResult.getBlockPos();
        level.playSound(null, blockPos, this.effectData.soundEvent(), SoundSource.BLOCKS, this.effectData.soundVolume(), this.effectData.soundPitch());
        if (level.isClientSide && this.effectData.particleEffect() != null) {
            RandomSource random = level.getRandom();
            for (int i = 0; i < this.effectData.particleCount(); ++i) {
                double spread = this.effectData.particleSpread();
                double x = (double)blockPos.getX() + 0.5 + (random.nextDouble() - 0.5) * spread;
                double y = (double)blockPos.getY() + 0.75 + (random.nextDouble() - 0.5) * spread;
                double z = (double)blockPos.getZ() + 0.5 + (random.nextDouble() - 0.5) * spread;
                level.addParticle(this.effectData.particleEffect(), x, y, z, 0.0, 0.0, 0.0);
            }
        }
        this.startCooldown(state, level, blockPos);
        level.gameEvent(entity, (Holder)GameEvent.BLOCK_ACTIVATE, blockPos);
        return true;
    }

    public void startCooldown(BlockState state, Level level, BlockPos pos) {
        level.setBlock(pos, (BlockState)state.setValue((Property)ON_COOLDOWN, (Comparable)Boolean.valueOf(true)), 3);
        level.updateNeighborsAt(pos, (Block)this);
        level.scheduleTick(pos, (Block)this, this.effectData.cooldownPeriod());
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.setBlock(pos, (BlockState)state.setValue((Property)ON_COOLDOWN, (Comparable)Boolean.valueOf(false)), 3);
        level.updateNeighborsAt(pos, (Block)this);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (!Services.PLATFORM.isClientSide()) {
            return;
        }
        if (!Screen.hasControlDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.plushables.holdctrl").withStyle(ChatFormatting.GRAY));
            return;
        }
        tooltipComponents.add((Component)Component.literal((String)this.tooltipData.number()).withStyle(ChatFormatting.YELLOW));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.plushables.artist").append(" \u00b7 " + this.tooltipData.artist()).withStyle(ChatFormatting.GREEN));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.plushables.created").append(" \u00b7 " + this.tooltipData.localizeDate(Minecraft.getInstance().getLanguageManager().getSelected())).withStyle(ChatFormatting.DARK_GREEN));
        if (this.tooltipData.trivia() != null) {
            tooltipComponents.add(CommonComponents.EMPTY);
            this.addTrivia(tooltipComponents, this.tooltipData.trivia());
        }
    }

    private void addTrivia(List<Component> tooltipComponents, String trivia) {
        String[] words = trivia.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            if (currentLine.length() + word.length() > 35) {
                tooltipComponents.add((Component)Component.literal((String)currentLine.toString().trim()).withStyle(ChatFormatting.GRAY));
                currentLine.setLength(0);
            }
            currentLine.append(word).append(" ");
        }
        if (!currentLine.isEmpty()) {
            tooltipComponents.add((Component)Component.literal((String)currentLine.toString().trim()).withStyle(ChatFormatting.GRAY));
        }
    }

    public VoxelShape useShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.create((double)0.0, (double)0.0, (double)0.0, (double)0.8, (double)0.8, (double)0.8));
        return shape;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        return VoxelShapeHelper.getSidedOutlineShape(direction, this.blockShape, this.blockShapes);
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ON_COOLDOWN, FACING, WATERLOGGED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)ON_COOLDOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).is((Fluid)Fluids.WATER)));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

