/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.plushables.block.interaction;

import com.khazoda.plushables.block.interaction.InteractionEffectData;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;

public class InteractionEffectBuilder {
    private SoundEvent soundEvent = InteractionEffectData.DEFAULT.soundEvent();
    private float soundVolume = InteractionEffectData.DEFAULT.soundVolume();
    private float soundPitch = InteractionEffectData.DEFAULT.soundPitch();
    private ParticleOptions particleEffect = InteractionEffectData.DEFAULT.particleEffect();
    private int particleCount = InteractionEffectData.DEFAULT.particleCount();
    private double particleSpread = InteractionEffectData.DEFAULT.particleSpread();
    private float particleYOffset = InteractionEffectData.DEFAULT.particleYOffset();
    private int cooldownPeriod = InteractionEffectData.DEFAULT.cooldownPeriod();
    private int lightLevel = InteractionEffectData.DEFAULT.lightLevel();

    public static InteractionEffectBuilder create() {
        return new InteractionEffectBuilder();
    }

    public InteractionEffectBuilder sound(Supplier<SoundEvent> supplier) {
        this.soundEvent = supplier.get();
        return this;
    }

    public InteractionEffectBuilder sound(SoundEvent event) {
        this.soundEvent = event;
        return this;
    }

    public InteractionEffectBuilder volume(float vol) {
        this.soundVolume = vol;
        return this;
    }

    public InteractionEffectBuilder pitch(float pitch) {
        this.soundPitch = pitch;
        return this;
    }

    public InteractionEffectBuilder particle(ParticleOptions effect) {
        this.particleEffect = effect;
        return this;
    }

    public InteractionEffectBuilder particleCount(int count) {
        this.particleCount = count;
        return this;
    }

    public InteractionEffectBuilder particleSpread(double spread) {
        this.particleSpread = spread;
        return this;
    }

    public InteractionEffectBuilder particleYOffset(float Yoffset) {
        this.particleYOffset = Yoffset;
        return this;
    }

    public InteractionEffectBuilder cooldown(int ticks) {
        this.cooldownPeriod = ticks;
        return this;
    }

    public InteractionEffectBuilder lightLevel(int level) {
        this.lightLevel = level;
        return this;
    }

    public InteractionEffectData build() {
        return new InteractionEffectData(this.soundEvent, this.soundVolume, this.soundPitch, this.particleEffect, this.particleCount, this.particleSpread, this.particleYOffset, this.cooldownPeriod, this.lightLevel);
    }
}

