/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.plushables.block.util;

import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapeHelper {
    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.empty()};
        int times = (to.get2DDataValue() - from.get2DDataValue() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.or((VoxelShape)buffer[1], (VoxelShape)Shapes.create((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.empty();
        }
        return buffer[0];
    }

    public static VoxelShape[] calculateBlockShapes(VoxelShape blockShape) {
        return new VoxelShape[]{blockShape, VoxelShapeHelper.rotateShape(Direction.NORTH, Direction.EAST, blockShape), VoxelShapeHelper.rotateShape(Direction.NORTH, Direction.SOUTH, blockShape), VoxelShapeHelper.rotateShape(Direction.NORTH, Direction.WEST, blockShape)};
    }

    public static VoxelShape getSidedOutlineShape(Direction direction, VoxelShape blockShape, VoxelShape[] blockShapes) {
        return switch (direction) {
            case Direction.NORTH -> blockShapes[0];
            case Direction.EAST -> blockShapes[1];
            case Direction.SOUTH -> blockShapes[2];
            case Direction.WEST -> blockShapes[3];
            default -> blockShape;
        };
    }
}

