/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.blockentities;

import com.github.L_Ender.cataclysm.entity.AnimationMonster.BossMonsters.Ender_Guardian_Entity;
import com.github.L_Ender.cataclysm.init.ModEntities;
import com.github.L_Ender.cataclysm.init.ModTileentites;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class AltarOfVoid_Block_Entity
extends BlockEntity {
    protected static final int SHORT_RANGE = 6;
    protected boolean spawnedBoss = false;

    public AltarOfVoid_Block_Entity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileentites.ALTAR_OF_VOID.get(), pos, state);
    }

    public static void commonTick(Level level, BlockPos pos, BlockState state, AltarOfVoid_Block_Entity entity) {
        entity.tick(level, pos, state, entity);
    }

    public boolean anyPlayerInRange(Level level, BlockPos pos) {
        return level.hasNearbyAlivePlayer((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (double)this.getRange());
    }

    public void tick(Level level, BlockPos pos, BlockState state, AltarOfVoid_Block_Entity te) {
        if (this.spawnedBoss || !this.anyPlayerInRange(level, pos)) {
            return;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (level.getDifficulty() != Difficulty.PEACEFUL && this.spawnMyBoss(serverLevel, pos)) {
                level.destroyBlock(pos, false);
                this.spawnedBoss = true;
            }
        }
    }

    protected boolean spawnMyBoss(ServerLevel serverLevel, BlockPos pos) {
        Vec3 vec3 = Vec3.atLowerCornerWithOffset((Vec3i)pos, (double)0.5, (double)0.0, (double)0.5);
        Ender_Guardian_Entity entity = (Ender_Guardian_Entity)((EntityType)ModEntities.ENDER_GUARDIAN.get()).create((Level)serverLevel);
        if (entity != null) {
            entity.setPos(vec3);
            entity.setHomePos(pos);
            entity.setUsedMassDestruction(false);
            entity.finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(this.worldPosition), MobSpawnType.SPAWNER, null);
            ResourceLocation dimLoc = serverLevel.dimension().location();
            entity.setDimensionType(dimLoc.toString());
            return serverLevel.addFreshEntity((Entity)entity);
        }
        return false;
    }

    protected int getRange() {
        return 6;
    }
}

