/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.client.render.entity;

import com.github.L_Ender.cataclysm.client.model.CMModelLayers;
import com.github.L_Ender.cataclysm.client.model.entity.Ceraunus_Model;
import com.github.L_Ender.cataclysm.client.model.entity.Scylla_Model;
import com.github.L_Ender.cataclysm.client.render.entity.Scylla_Renderer;
import com.github.L_Ender.cataclysm.entity.InternalAnimationMonster.IABossMonsters.Scylla.Scylla_Ceraunus_Entity;
import com.github.L_Ender.cataclysm.entity.InternalAnimationMonster.IABossMonsters.Scylla.Scylla_Entity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Scylla_Ceraunus_Renderer
extends EntityRenderer<Scylla_Ceraunus_Entity> {
    private final Ceraunus_Model model;
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)"textures/entity/scylla/ceraunus.png");
    private static final ResourceLocation CHAIN_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)"textures/entity/scylla/scylla_chain.png");

    public Scylla_Ceraunus_Renderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn);
        this.model = new Ceraunus_Model(renderManagerIn.bakeLayer(CMModelLayers.CERAUNUS_MODEL));
    }

    public void render(Scylla_Ceraunus_Entity entity, float yaw, float tickDelta, PoseStack matrices, MultiBufferSource provider, int light) {
        matrices.pushPose();
        float yRot = Mth.lerp((float)tickDelta, (float)entity.yRotO, (float)entity.getYRot());
        float xRot = Mth.lerp((float)tickDelta, (float)entity.xRotO, (float)entity.getXRot());
        matrices.mulPose(Axis.YP.rotationDegrees(yRot - 90.0f));
        matrices.mulPose(Axis.ZP.rotationDegrees(xRot + 90.0f));
        VertexConsumer vertexConsumer = provider.getBuffer(this.model.renderType(this.getTextureLocation(entity)));
        this.model.renderToBuffer(matrices, vertexConsumer, light, OverlayTexture.NO_OVERLAY);
        matrices.popPose();
        Entity fromEntity = entity.getController();
        if (fromEntity != null) {
            Vec3 entityPos = entity.getPosition(tickDelta);
            PoseStack poseForModel = new PoseStack();
            poseForModel.mulPose(Axis.YP.rotationDegrees(yRot - 90.0f));
            poseForModel.mulPose(Axis.ZP.rotationDegrees(xRot + 90.0f));
            Vec3 modelOffset = this.model.getChainPosition(new Vec3(0.0, 0.0, 0.0), poseForModel);
            Vec3 fromPos = this.getPositionOfPriorMob(fromEntity, tickDelta);
            Vec3 chainTo = fromPos.subtract(entityPos);
            Vec3 chainBase = modelOffset;
            matrices.pushPose();
            matrices.translate(chainBase.x, chainBase.y, chainBase.z);
            VertexConsumer chainBuffer = provider.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)CHAIN_TEXTURE));
            Scylla_Ceraunus_Renderer.renderChainCube(chainTo.subtract(chainBase), matrices, chainBuffer, light, OverlayTexture.NO_OVERLAY);
            matrices.popPose();
        }
    }

    public boolean shouldRender(Scylla_Ceraunus_Entity entity, Frustum camera, double camX, double camY, double camZ) {
        if (super.shouldRender((Entity)entity, camera, camX, camY, camZ)) {
            return true;
        }
        Entity weapon = entity.getController();
        if (weapon != null) {
            Vec3 vec3 = entity.position();
            Vec3 vec31 = weapon.position();
            return camera.isVisible(new AABB(vec31.x, vec31.y, vec31.z, vec3.x, vec3.y, vec3.z));
        }
        return false;
    }

    private Vec3 getPositionOfPriorMob(Entity mob, float partialTicks) {
        double d4 = Mth.lerp((double)partialTicks, (double)mob.xo, (double)mob.getX());
        double d5 = Mth.lerp((double)partialTicks, (double)mob.yo, (double)mob.getY());
        double d6 = Mth.lerp((double)partialTicks, (double)mob.zo, (double)mob.getZ());
        if (mob instanceof Scylla_Entity) {
            Scylla_Renderer livingRenderer;
            EntityModel anchorModel;
            Scylla_Entity living = (Scylla_Entity)mob;
            float bodyYaw = Mth.rotLerp((float)partialTicks, (float)living.yBodyRotO, (float)living.yBodyRot);
            EntityRenderer anchorRenderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)living);
            if (anchorRenderer instanceof Scylla_Renderer && (anchorModel = (livingRenderer = (Scylla_Renderer)anchorRenderer).getModel()) instanceof Scylla_Model) {
                Scylla_Model targetModel = (Scylla_Model)anchorModel;
                Vec3 toPos = targetModel.getHandPosition(new Vec3(0.0, 0.0, 0.0)).yRot((float)(Math.PI - (double)(bodyYaw * ((float)Math.PI / 180))));
                return new Vec3(d4 + toPos.x, d5 + toPos.y, d6 + toPos.z);
            }
        }
        return new Vec3(d4, d5, d6);
    }

    public static void renderChainCube(Vec3 to, PoseStack poseStack, VertexConsumer buffer, int packedLightIn, int setOverlay) {
        double d = to.horizontalDistance();
        float rotY = (float)(Mth.atan2((double)to.x, (double)to.z) * 57.2957763671875);
        float rotX = (float)(-(Mth.atan2((double)to.y, (double)d) * 57.2957763671875)) - 90.0f;
        float chainWidth = 0.1875f;
        float chainOffset = chainWidth * -0.5f;
        float chainLength = (float)to.length() / 2.3f;
        poseStack.pushPose();
        poseStack.scale(2.3f, 2.3f, 2.3f);
        poseStack.mulPose(Axis.YP.rotationDegrees(rotY));
        poseStack.mulPose(Axis.XP.rotationDegrees(rotX));
        poseStack.translate(0.0f, -chainLength, 0.0f);
        PoseStack.Pose posestack$pose = poseStack.last();
        buffer.addVertex(posestack$pose, chainOffset, 0.0f, 0.0f).setColor(255, 255, 255, 255).setUv(0.0f, chainLength).setOverlay(setOverlay).setLight(packedLightIn).setNormal(posestack$pose, 0.0f, 1.0f, 0.0f);
        buffer.addVertex(posestack$pose, chainWidth + chainOffset, 0.0f, 0.0f).setColor(255, 255, 255, 255).setUv(chainWidth, chainLength).setOverlay(setOverlay).setLight(packedLightIn).setNormal(posestack$pose, 0.0f, 1.0f, 0.0f);
        buffer.addVertex(posestack$pose, chainWidth + chainOffset, chainLength, 0.0f).setColor(255, 255, 255, 255).setUv(chainWidth, 0.0f).setOverlay(setOverlay).setLight(packedLightIn).setNormal(posestack$pose, 0.0f, 1.0f, 0.0f);
        buffer.addVertex(posestack$pose, chainOffset, chainLength, 0.0f).setColor(255, 255, 255, 255).setUv(0.0f, 0.0f).setOverlay(setOverlay).setLight(packedLightIn).setNormal(posestack$pose, 0.0f, 1.0f, 0.0f);
        float pixelSkip = 0.25f;
        buffer.addVertex(posestack$pose, 0.0f, pixelSkip, chainOffset).setColor(255, 255, 255, 255).setUv(chainWidth, chainLength + pixelSkip).setOverlay(setOverlay).setLight(packedLightIn).setNormal(posestack$pose, 0.0f, 1.0f, 0.0f);
        buffer.addVertex(posestack$pose, 0.0f, pixelSkip, chainWidth + chainOffset).setColor(255, 255, 255, 255).setUv(chainWidth * 2.0f, chainLength + pixelSkip).setOverlay(setOverlay).setLight(packedLightIn).setNormal(posestack$pose, 0.0f, 1.0f, 0.0f);
        buffer.addVertex(posestack$pose, 0.0f, chainLength + pixelSkip, chainWidth + chainOffset).setColor(255, 255, 255, 255).setUv(chainWidth * 2.0f, pixelSkip).setOverlay(setOverlay).setLight(packedLightIn).setNormal(posestack$pose, 0.0f, 1.0f, 0.0f);
        buffer.addVertex(posestack$pose, 0.0f, chainLength + pixelSkip, chainOffset).setColor(255, 255, 255, 255).setUv(chainWidth, pixelSkip).setOverlay(setOverlay).setLight(packedLightIn).setNormal(posestack$pose, 0.0f, 1.0f, 0.0f);
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(Scylla_Ceraunus_Entity entity) {
        return TEXTURE;
    }
}

