/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.structures;

import com.github.L_Ender.cataclysm.entity.AnimationMonster.BossMonsters.Ignited_Revenant_Entity;
import com.github.L_Ender.cataclysm.init.ModEntities;
import com.github.L_Ender.cataclysm.init.ModStructures;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProtectedBlockProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class Burning_Arena_Structure
extends Structure {
    public static final MapCodec<Burning_Arena_Structure> CODEC = Burning_Arena_Structure.simpleCodec(Burning_Arena_Structure::new);
    private static final ResourceLocation ARENA1 = ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)"burning_arena1");
    private static final ResourceLocation ARENA2 = ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)"burning_arena2");
    private static final ResourceLocation ARENA3 = ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)"burning_arena3");
    private static final ResourceLocation ARENA4 = ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)"burning_arena4");
    private static final ResourceLocation ARENA5 = ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)"burning_arena5");
    private static final ResourceLocation ARENA6 = ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)"burning_arena6");
    private static final ResourceLocation ARENA7 = ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)"burning_arena7");
    private static final ResourceLocation ARENA8 = ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)"burning_arena8");
    private static final Map<ResourceLocation, BlockPos> OFFSET = ImmutableMap.builder().put((Object)ARENA1, (Object)new BlockPos(0, 1, 0)).put((Object)ARENA2, (Object)new BlockPos(0, 1, 0)).put((Object)ARENA3, (Object)new BlockPos(0, 1, 0)).put((Object)ARENA4, (Object)new BlockPos(0, 1, 0)).put((Object)ARENA5, (Object)new BlockPos(0, 1, 0)).put((Object)ARENA6, (Object)new BlockPos(0, 1, 0)).put((Object)ARENA7, (Object)new BlockPos(0, 1, 0)).put((Object)ARENA8, (Object)new BlockPos(0, 1, 0)).build();

    public static void start(StructureTemplateManager templateManager, BlockPos pos, Rotation rotation, StructurePieceAccessor pieceList, RandomSource random) {
        int x = pos.getX();
        int z = pos.getZ();
        BlockPos rotationOffSet = new BlockPos(0, 0, 0).rotate(rotation);
        BlockPos blockpos = rotationOffSet.offset(x, pos.getY(), z);
        pieceList.addPiece((StructurePiece)new Piece(templateManager, ARENA1, blockpos, rotation));
        rotationOffSet = new BlockPos(0, 0, 38).rotate(rotation);
        blockpos = rotationOffSet.offset(x, pos.getY(), z);
        pieceList.addPiece((StructurePiece)new Piece(templateManager, ARENA2, blockpos, rotation));
        rotationOffSet = new BlockPos(47, 0, 0).rotate(rotation);
        blockpos = rotationOffSet.offset(x, pos.getY(), z);
        pieceList.addPiece((StructurePiece)new Piece(templateManager, ARENA3, blockpos, rotation));
        rotationOffSet = new BlockPos(47, 0, 38).rotate(rotation);
        blockpos = rotationOffSet.offset(x, pos.getY(), z);
        pieceList.addPiece((StructurePiece)new Piece(templateManager, ARENA4, blockpos, rotation));
        rotationOffSet = new BlockPos(0, 48, 0).rotate(rotation);
        blockpos = rotationOffSet.offset(x, pos.getY(), z);
        pieceList.addPiece((StructurePiece)new Piece(templateManager, ARENA5, blockpos, rotation));
        rotationOffSet = new BlockPos(0, 48, 38).rotate(rotation);
        blockpos = rotationOffSet.offset(x, pos.getY(), z);
        pieceList.addPiece((StructurePiece)new Piece(templateManager, ARENA6, blockpos, rotation));
        rotationOffSet = new BlockPos(47, 48, 0).rotate(rotation);
        blockpos = rotationOffSet.offset(x, pos.getY(), z);
        pieceList.addPiece((StructurePiece)new Piece(templateManager, ARENA7, blockpos, rotation));
        rotationOffSet = new BlockPos(47, 48, 38).rotate(rotation);
        blockpos = rotationOffSet.offset(x, pos.getY(), z);
        pieceList.addPiece((StructurePiece)new Piece(templateManager, ARENA8, blockpos, rotation));
    }

    public Burning_Arena_Structure(Structure.StructureSettings p_227593_) {
        super(p_227593_);
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext p_228964_) {
        int i = p_228964_.chunkPos().x >> 16;
        int j = p_228964_.chunkPos().z >> 16;
        BlockPos blockpos = new BlockPos(p_228964_.chunkPos().getMinBlockX(), 21, p_228964_.chunkPos().getMinBlockZ());
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        worldgenrandom.setSeed((long)(i ^ j << 9) ^ p_228964_.seed());
        worldgenrandom.nextInt();
        return Optional.of(new Structure.GenerationStub(blockpos, p_228526_ -> Burning_Arena_Structure.generatePieces(p_228526_, p_228964_)));
    }

    private static void generatePieces(StructurePiecesBuilder p_197233_, Structure.GenerationContext p_197234_) {
        BlockPos blockpos = new BlockPos(p_197234_.chunkPos().getMinBlockX(), 21, p_197234_.chunkPos().getMinBlockZ());
        Rotation rotation = Rotation.getRandom((RandomSource)p_197234_.random());
        Burning_Arena_Structure.start(p_197234_.structureTemplateManager(), blockpos, rotation, (StructurePieceAccessor)p_197233_, (RandomSource)p_197234_.random());
    }

    public StructureType<?> type() {
        return (StructureType)ModStructures.BURNING_ARENA.get();
    }

    public GenerationStep.Decoration step() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    public static class Piece
    extends TemplateStructurePiece {
        public Piece(StructureTemplateManager templateManagerIn, ResourceLocation resourceLocationIn, BlockPos pos, Rotation rotation) {
            super((StructurePieceType)ModStructures.BAP.get(), 0, templateManagerIn, resourceLocationIn, resourceLocationIn.toString(), Piece.makeSettings(rotation), Piece.makePosition(resourceLocationIn, pos));
        }

        public Piece(StructureTemplateManager templateManagerIn, CompoundTag tagCompound) {
            super((StructurePieceType)ModStructures.BAP.get(), tagCompound, templateManagerIn, p_162451_ -> Piece.makeSettings(Rotation.valueOf((String)tagCompound.getString("Rot"))));
        }

        public Piece(StructurePieceSerializationContext context, CompoundTag tag) {
            this(context.structureTemplateManager(), tag);
        }

        private static StructurePlaceSettings makeSettings(Rotation p_163156_) {
            BlockIgnoreProcessor blockignoreprocessor = BlockIgnoreProcessor.STRUCTURE_BLOCK;
            StructurePlaceSettings structureplacesettings = new StructurePlaceSettings().setRotation(p_163156_).setMirror(Mirror.NONE).addProcessor((StructureProcessor)blockignoreprocessor).addProcessor((StructureProcessor)new ProtectedBlockProcessor(BlockTags.FEATURES_CANNOT_REPLACE));
            return structureplacesettings;
        }

        private static BlockPos makePosition(ResourceLocation p_162453_, BlockPos p_162454_) {
            return p_162454_.offset((Vec3i)OFFSET.get(p_162453_));
        }

        protected void addAdditionalSaveData(StructurePieceSerializationContext p_162444_, CompoundTag tagCompound) {
            super.addAdditionalSaveData(p_162444_, tagCompound);
            tagCompound.putString("Rot", this.placeSettings.getRotation().name());
        }

        protected void handleDataMarker(String function, BlockPos pos, ServerLevelAccessor worldIn, RandomSource rand, BoundingBox sbb) {
            if ("revenant".equals(function)) {
                worldIn.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
                Ignited_Revenant_Entity revenant = (Ignited_Revenant_Entity)((EntityType)ModEntities.IGNITED_REVENANT.get()).create((Level)worldIn.getLevel());
                revenant.moveTo(pos, 180.0f, 180.0f);
                worldIn.addFreshEntity((Entity)revenant);
            }
        }
    }
}

