/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.decoration.kinetics.encased;

import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.simibubi.create.api.contraption.transformable.TransformableBlock;
import com.simibubi.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.decoration.encasing.EncasedBlock;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.content.kinetics.simpleRelays.SimpleKineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.encased.EncasedCogwheelBlock;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.block.IBE;
import com.tterrag.registrate.util.entry.BlockEntityEntry;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.function.Supplier;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class TFMGEncasedCogwheelBlock
extends RotatedPillarKineticBlock
implements ICogWheel,
IBE<SimpleKineticBlockEntity>,
SpecialBlockItemRequirement,
TransformableBlock,
EncasedBlock {
    public static final BooleanProperty TOP_SHAFT = EncasedCogwheelBlock.TOP_SHAFT;
    public static final BooleanProperty BOTTOM_SHAFT = EncasedCogwheelBlock.BOTTOM_SHAFT;
    protected final boolean isLarge;
    private final Supplier<Block> casing;
    private final BlockEntry<?> blockSmall;
    private final BlockEntry<?> blockLarge;
    private final BlockEntityEntry<SimpleKineticBlockEntity> beSmall;
    private final BlockEntityEntry<SimpleKineticBlockEntity> beLarge;

    public static TFMGEncasedCogwheelBlock steel(BlockBehaviour.Properties properties, boolean large, Supplier<Block> casing) {
        return new TFMGEncasedCogwheelBlock(properties, large, casing, TFMGBlocks.STEEL_COGWHEEL, TFMGBlocks.LARGE_STEEL_COGWHEEL, TFMGBlockEntities.ENCASED_STEEL_COGWHEEL, TFMGBlockEntities.ENCASED_LARGE_STEEL_COGWHEEL);
    }

    public static TFMGEncasedCogwheelBlock aluminum(BlockBehaviour.Properties properties, boolean large, Supplier<Block> casing) {
        return new TFMGEncasedCogwheelBlock(properties, large, casing, TFMGBlocks.ALUMINUM_COGWHEEL, TFMGBlocks.LARGE_ALUMINUM_COGWHEEL, TFMGBlockEntities.ENCASED_ALUMINUM_COGWHEEL, TFMGBlockEntities.ENCASED_LARGE_ALUMINUM_COGWHEEL);
    }

    public TFMGEncasedCogwheelBlock(BlockBehaviour.Properties properties, boolean large, Supplier<Block> casing, BlockEntry<?> blockSmall, BlockEntry<?> blockLarge, BlockEntityEntry<SimpleKineticBlockEntity> beSmall, BlockEntityEntry<SimpleKineticBlockEntity> beLarge) {
        super(properties);
        this.beSmall = beSmall;
        this.beLarge = beLarge;
        this.blockSmall = blockSmall;
        this.blockLarge = blockLarge;
        this.isLarge = large;
        this.casing = casing;
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TOP_SHAFT, (Comparable)Boolean.valueOf(false))).setValue((Property)BOTTOM_SHAFT, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{TOP_SHAFT, BOTTOM_SHAFT}));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState placedOn = context.getLevel().getBlockState(context.getClickedPos().relative(context.getClickedFace().getOpposite()));
        BlockState stateForPlacement = super.getStateForPlacement(context);
        if (ICogWheel.isSmallCog((BlockState)placedOn)) {
            stateForPlacement = (BlockState)stateForPlacement.setValue((Property)AXIS, (Comparable)((IRotate)placedOn.getBlock()).getRotationAxis(placedOn));
        }
        return stateForPlacement;
    }

    public boolean skipRendering(BlockState pState, BlockState pAdjacentBlockState, Direction pDirection) {
        return pState.getBlock() == pAdjacentBlockState.getBlock() && pState.getValue((Property)AXIS) == pAdjacentBlockState.getValue((Property)AXIS);
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (context.getClickedFace().getAxis() != state.getValue((Property)AXIS)) {
            return super.onWrenched(state, context);
        }
        Level level = context.getLevel();
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockPos pos = context.getClickedPos();
        KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)pos, (BlockState)((BlockState)state.cycle((Property)(context.getClickedFace().getAxisDirection() == Direction.AxisDirection.POSITIVE ? TOP_SHAFT : BOTTOM_SHAFT))));
        IWrenchable.playRotateSound((Level)level, (BlockPos)pos);
        return InteractionResult.SUCCESS;
    }

    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        originalState = this.swapShaftsForRotation(originalState, Rotation.CLOCKWISE_90, targetedFace.getAxis());
        return (BlockState)originalState.setValue((Property)RotatedPillarKineticBlock.AXIS, (Comparable)VoxelShaper.axisAsFace((Direction.Axis)((Direction.Axis)originalState.getValue((Property)RotatedPillarKineticBlock.AXIS))).getClockWise(targetedFace.getAxis()).getAxis());
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        if (context.getLevel().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        context.getLevel().levelEvent(2001, context.getClickedPos(), Block.getId((BlockState)state));
        KineticBlockEntity.switchToBlockState((Level)context.getLevel(), (BlockPos)context.getClickedPos(), (BlockState)((BlockState)(this.isLarge ? this.blockLarge : this.blockSmall).getDefaultState().setValue((Property)AXIS, (Comparable)((Direction.Axis)state.getValue((Property)AXIS)))));
        return InteractionResult.SUCCESS;
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.getAxis() == state.getValue((Property)AXIS) && (Boolean)state.getValue((Property)(face.getAxisDirection() == Direction.AxisDirection.POSITIVE ? TOP_SHAFT : BOTTOM_SHAFT)) != false;
    }

    protected boolean areStatesKineticallyEquivalent(BlockState oldState, BlockState newState) {
        if (newState.getBlock() instanceof TFMGEncasedCogwheelBlock && oldState.getBlock() instanceof TFMGEncasedCogwheelBlock) {
            if (newState.getValue((Property)TOP_SHAFT) != oldState.getValue((Property)TOP_SHAFT)) {
                return false;
            }
            if (newState.getValue((Property)BOTTOM_SHAFT) != oldState.getValue((Property)BOTTOM_SHAFT)) {
                return false;
            }
        }
        return super.areStatesKineticallyEquivalent(oldState, newState);
    }

    public boolean isSmallCog() {
        return !this.isLarge;
    }

    public boolean isLargeCog() {
        return this.isLarge;
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        return CogWheelBlock.isValidCogwheelPosition((boolean)ICogWheel.isLargeCog((BlockState)state), (LevelReader)worldIn, (BlockPos)pos, (Direction.Axis)((Direction.Axis)state.getValue((Property)AXIS)));
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return (Direction.Axis)state.getValue((Property)AXIS);
    }

    public BlockState swapShafts(BlockState state) {
        boolean bottom = (Boolean)state.getValue((Property)BOTTOM_SHAFT);
        boolean top = (Boolean)state.getValue((Property)TOP_SHAFT);
        state = (BlockState)state.setValue((Property)BOTTOM_SHAFT, (Comparable)Boolean.valueOf(top));
        state = (BlockState)state.setValue((Property)TOP_SHAFT, (Comparable)Boolean.valueOf(bottom));
        return state;
    }

    public BlockState swapShaftsForRotation(BlockState state, Rotation rotation, Direction.Axis rotationAxis) {
        boolean clockwise;
        if (rotation == Rotation.NONE) {
            return state;
        }
        Direction.Axis axis = (Direction.Axis)state.getValue((Property)AXIS);
        if (axis == rotationAxis) {
            return state;
        }
        if (rotation == Rotation.CLOCKWISE_180) {
            return this.swapShafts(state);
        }
        boolean bl = clockwise = rotation == Rotation.CLOCKWISE_90;
        if (rotationAxis == Direction.Axis.X ? axis == Direction.Axis.Z && !clockwise || axis == Direction.Axis.Y && clockwise : (rotationAxis == Direction.Axis.Y ? axis == Direction.Axis.X && !clockwise || axis == Direction.Axis.Z && clockwise : rotationAxis == Direction.Axis.Z && (axis == Direction.Axis.Y && !clockwise || axis == Direction.Axis.X && clockwise))) {
            return this.swapShafts(state);
        }
        return state;
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        Direction.Axis axis = (Direction.Axis)state.getValue((Property)AXIS);
        if (axis == Direction.Axis.X && mirror == Mirror.FRONT_BACK || axis == Direction.Axis.Z && mirror == Mirror.LEFT_RIGHT) {
            return this.swapShafts(state);
        }
        return state;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        state = this.swapShaftsForRotation(state, rotation, Direction.Axis.Y);
        return super.rotate(state, rotation);
    }

    public BlockState transform(BlockState state, StructureTransform transform) {
        if (transform.mirror != null) {
            state = this.mirror(state, transform.mirror);
        }
        if (transform.rotationAxis == Direction.Axis.Y) {
            return this.rotate(state, transform.rotation);
        }
        state = this.swapShaftsForRotation(state, transform.rotation, transform.rotationAxis);
        state = (BlockState)state.setValue((Property)AXIS, (Comparable)transform.rotateAxis((Direction.Axis)state.getValue((Property)AXIS)));
        return state;
    }

    public ItemRequirement getRequiredItems(BlockState state, BlockEntity be) {
        return ItemRequirement.of((BlockState)(this.isLarge ? this.blockLarge.getDefaultState() : this.blockSmall.getDefaultState()), (BlockEntity)be);
    }

    public Class<SimpleKineticBlockEntity> getBlockEntityClass() {
        return SimpleKineticBlockEntity.class;
    }

    public BlockEntityType<? extends SimpleKineticBlockEntity> getBlockEntityType() {
        return this.isLarge ? (BlockEntityType)this.beLarge.get() : (BlockEntityType)this.beSmall.get();
    }

    public Block getCasing() {
        return this.casing.get();
    }

    public void handleEncasing(BlockState state, Level level, BlockPos pos, ItemStack heldItem, Player player, InteractionHand hand, BlockHitResult ray) {
        BlockState encasedState = (BlockState)this.defaultBlockState().setValue((Property)AXIS, (Comparable)((Direction.Axis)state.getValue((Property)AXIS)));
        for (Direction d : Iterate.directionsInAxis((Direction.Axis)((Direction.Axis)state.getValue((Property)AXIS)))) {
            IRotate def;
            BlockState adjacentState = level.getBlockState(pos.relative(d));
            if (!(adjacentState.getBlock() instanceof IRotate) || !(def = (IRotate)adjacentState.getBlock()).hasShaftTowards((LevelReader)level, pos.relative(d), adjacentState, d.getOpposite())) continue;
            encasedState = (BlockState)encasedState.cycle((Property)(d.getAxisDirection() == Direction.AxisDirection.POSITIVE ? TOP_SHAFT : BOTTOM_SHAFT));
        }
        KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)pos, (BlockState)encasedState);
    }
}

