/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.decoration.kinetics.flywheels;

import com.drmangotea.tfmg.mixin.accessor.FlywheelBlockEntityMixin;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.flywheel.FlywheelBlockEntity;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class TFMGFlywheelRenderer
extends KineticBlockEntityRenderer<FlywheelBlockEntity> {
    public TFMGFlywheelRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(FlywheelBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((KineticBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        if (VisualizationManager.supportsVisualization((LevelAccessor)be.getLevel())) {
            return;
        }
        BlockState blockState = be.getBlockState();
        float speed = ((FlywheelBlockEntityMixin)be).tfmg$visualSpeed().getValue(partialTicks) * 3.0f / 10.0f;
        float angle = ((FlywheelBlockEntityMixin)be).tfmg$angle() + speed * partialTicks;
        VertexConsumer vb = buffer.getBuffer(RenderType.solid());
        this.renderFlywheel(be, ms, light, blockState, angle, vb);
    }

    private void renderFlywheel(FlywheelBlockEntity be, PoseStack ms, int light, BlockState blockState, float angle, VertexConsumer vb) {
        SuperByteBuffer wheel = CachedBuffers.block((BlockState)blockState);
        TFMGFlywheelRenderer.kineticRotationTransform((SuperByteBuffer)wheel, (KineticBlockEntity)be, (Direction.Axis)TFMGFlywheelRenderer.getRotationAxisOf((KineticBlockEntity)be), (float)AngleHelper.rad((double)angle), (int)light);
        wheel.renderInto(ms, vb);
    }

    protected BlockState getRenderedBlockState(FlywheelBlockEntity be) {
        return TFMGFlywheelRenderer.shaft((Direction.Axis)TFMGFlywheelRenderer.getRotationAxisOf((KineticBlockEntity)be));
    }
}

