/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.decoration.pipes;

import com.drmangotea.tfmg.content.decoration.pipes.TFMGPipeBlockEntity;
import com.drmangotea.tfmg.content.decoration.pipes.TFMGPipes;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.decoration.bracket.BracketedBlockEntityBehaviour;
import com.simibubi.create.content.fluids.FluidPropagator;
import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlockEntity;
import com.simibubi.create.content.fluids.pipes.GlassFluidPipeBlock;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class TFMGPipeBlock
extends FluidPipeBlock {
    public final TFMGPipes.PipeMaterial material;

    public TFMGPipeBlock(BlockBehaviour.Properties properties, TFMGPipes.PipeMaterial material) {
        super(properties);
        this.material = material;
    }

    public BlockState updateBlockState(BlockState state, Direction preferredDirection, @Nullable Direction ignore, BlockAndTintGetter world, BlockPos pos) {
        if (world.getBlockEntity(pos) instanceof TFMGPipeBlockEntity && ((TFMGPipeBlockEntity)world.getBlockEntity((BlockPos)pos)).locked) {
            return state;
        }
        BracketedBlockEntityBehaviour bracket = (BracketedBlockEntityBehaviour)BlockEntityBehaviour.get((BlockGetter)world, (BlockPos)pos, (BehaviourType)BracketedBlockEntityBehaviour.TYPE);
        if (bracket != null && bracket.isBracketPresent()) {
            return state;
        }
        BlockState prevState = state;
        int prevStateSides = (int)Arrays.stream(Iterate.directions).map(PROPERTY_BY_DIRECTION::get).filter(arg_0 -> ((BlockState)prevState).getValue(arg_0)).count();
        for (Direction d : Iterate.directions) {
            if (d == ignore) continue;
            boolean shouldConnect = TFMGPipeBlock.canConnectTo((BlockAndTintGetter)world, (BlockPos)pos.relative(d), (BlockState)world.getBlockState(pos.relative(d)), (Direction)d);
            if (world.getBlockEntity(pos.relative(d)) instanceof TFMGPipeBlockEntity && ((TFMGPipeBlockEntity)world.getBlockEntity((BlockPos)pos.relative((Direction)d))).locked) {
                shouldConnect = false;
                if (((Boolean)world.getBlockState(pos.relative(d)).getValue((Property)PROPERTY_BY_DIRECTION.get(d.getOpposite()))).booleanValue()) {
                    shouldConnect = true;
                }
            }
            state = (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(d), (Comparable)Boolean.valueOf(shouldConnect));
        }
        Direction connectedDirection = null;
        for (Direction d : Iterate.directions) {
            if (!TFMGPipeBlock.isOpenAt((BlockState)state, (Direction)d)) continue;
            if (connectedDirection != null) {
                return state;
            }
            connectedDirection = d;
        }
        if (connectedDirection != null) {
            return (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(connectedDirection.getOpposite()), (Comparable)Boolean.valueOf(true));
        }
        if (prevStateSides == 2) {
            return prevState;
        }
        return (BlockState)((BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(preferredDirection), (Comparable)Boolean.valueOf(true))).setValue((Property)PROPERTY_BY_DIRECTION.get(preferredDirection.getOpposite()), (Comparable)Boolean.valueOf(true));
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource r) {
        super.tick(state, world, pos, r);
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (this.tryRemoveBracket(context)) {
            return InteractionResult.SUCCESS;
        }
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction clickedFace = context.getClickedFace();
        Direction.Axis axis = this.getAxis((BlockGetter)world, pos, state);
        if (axis == null) {
            Vec3 clickLocation = context.getClickLocation().subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
            double closest = 3.4028234663852886E38;
            Direction argClosest = Direction.UP;
            for (Direction direction : Iterate.directions) {
                Vec3 centerOf;
                double distance;
                if (clickedFace.getAxis() == direction.getAxis() || !((distance = (centerOf = Vec3.atCenterOf((Vec3i)direction.getNormal())).distanceToSqr(clickLocation)) < closest)) continue;
                closest = distance;
                argClosest = direction;
            }
            axis = argClosest.getAxis();
        }
        if (clickedFace.getAxis() == axis) {
            return InteractionResult.PASS;
        }
        if (!world.isClientSide) {
            this.withBlockEntityDo((BlockGetter)world, pos, fpte -> ((FluidTransportBehaviour)fpte.getBehaviour((BehaviourType)FluidTransportBehaviour.TYPE)).interfaces.values().stream().filter(pc -> pc != null && pc.hasFlow()).findAny().ifPresent($ -> AllAdvancements.GLASS_PIPE.awardTo(context.getPlayer())));
            FluidTransportBehaviour.cacheFlows((LevelAccessor)world, (BlockPos)pos);
            world.setBlockAndUpdate(pos, (BlockState)((BlockState)TFMGPipes.PIPES.get((Object)this.material).getGlass().getDefaultState().setValue((Property)GlassFluidPipeBlock.AXIS, (Comparable)axis)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED))));
            FluidTransportBehaviour.loadFlows((LevelAccessor)world, (BlockPos)pos);
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    private Direction.Axis getAxis(BlockGetter world, BlockPos pos, BlockState state) {
        return FluidPropagator.getStraightPipeAxis((BlockState)state);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!AllBlocks.COPPER_CASING.isIn(player.getItemInHand(hand))) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (world.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        FluidTransportBehaviour.cacheFlows((LevelAccessor)world, (BlockPos)pos);
        world.setBlockAndUpdate(pos, EncasedPipeBlock.transferSixWayProperties((BlockState)state, (BlockState)TFMGPipes.PIPES.get((Object)this.material).getEncased().getDefaultState()));
        FluidTransportBehaviour.loadFlows((LevelAccessor)world, (BlockPos)pos);
        return ItemInteractionResult.SUCCESS;
    }

    public Class<FluidPipeBlockEntity> getBlockEntityClass() {
        return FluidPipeBlockEntity.class;
    }

    public BlockEntityType<? extends FluidPipeBlockEntity> getBlockEntityType() {
        return (BlockEntityType)TFMGBlockEntities.TFMG_PIPE.get();
    }
}

