/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.connection.cables;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.content.electricity.connection.cable_type.CableType;
import com.drmangotea.tfmg.content.electricity.connection.cables.CablePos;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class CableConnection {
    public final CablePos pos1;
    public final CablePos pos2;
    public final BlockPos blockPos1;
    public final boolean visible;
    public final CableType type;

    public CableConnection(CablePos pos1, CablePos pos2, BlockPos blockPos1, CableType type, boolean visible) {
        this.pos1 = pos1;
        this.pos2 = pos2;
        this.blockPos1 = blockPos1;
        this.visible = visible;
        this.type = type;
    }

    public CompoundTag saveConnection() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putDouble("X1", this.pos1.x());
        compoundTag.putDouble("Y1", this.pos1.y());
        compoundTag.putDouble("Z1", this.pos1.z());
        compoundTag.putDouble("X2", this.pos2.x());
        compoundTag.putDouble("Y2", this.pos2.y());
        compoundTag.putDouble("Z2", this.pos2.z());
        compoundTag.putLong("Pos", this.blockPos1.asLong());
        compoundTag.putBoolean("Visible", this.visible);
        compoundTag.putString("CableType", this.type.getKey().toString());
        return compoundTag;
    }

    public static CableConnection loadConnection(CompoundTag compoundTag) {
        CablePos pos1 = new CablePos(compoundTag.getDouble("X1"), compoundTag.getDouble("Y1"), compoundTag.getDouble("Z1"));
        CablePos pos2 = new CablePos(compoundTag.getDouble("X2"), compoundTag.getDouble("Y2"), compoundTag.getDouble("Z2"));
        BlockPos blockPos1 = BlockPos.of((long)compoundTag.getLong("Pos"));
        boolean visible = compoundTag.getBoolean("Visible");
        CableType type = TFMGUtils.getCableType(ResourceLocation.parse((String)compoundTag.getString("CableType")));
        return new CableConnection(pos1, pos2, blockPos1, type, visible);
    }

    public float getLength() {
        return TFMGUtils.getDistance(new BlockPos((int)this.pos1.x(), (int)this.pos1.y(), (int)this.pos1.z()), new BlockPos((int)this.pos2.x(), (int)this.pos2.y(), (int)this.pos2.z()), false);
    }
}

