/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.utilities.polarizer;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.base.lang.TFMGTexts;
import com.drmangotea.tfmg.config.TFMGConfigs;
import com.drmangotea.tfmg.content.electricity.base.ElectricBlockEntity;
import com.drmangotea.tfmg.recipes.PolarizingRecipe;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.drmangotea.tfmg.registry.TFMGRecipeTypes;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.item.SmartInventory;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;

public class PolarizerBlockEntity
extends ElectricBlockEntity
implements IHaveGoggleInformation {
    public SmartInventory inventory = new SmartInventory(1, (SyncedBlockEntity)this, 1, false).whenContentsChanged(this::onInventoryChanged);
    public IItemHandlerModifiable itemCapability;
    LerpedFloat angle = LerpedFloat.angular();
    public boolean chargeCapacitors = false;
    public int capacitorPercentage = 0;

    public PolarizerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.itemCapability = this.inventory;
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)TFMGBlockEntities.POLARIZER.get(), (be, context) -> be.itemCapability);
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction == ((Direction)this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)).getOpposite();
    }

    public void onInventoryChanged(int count) {
        this.sendData();
        this.setChanged();
        if (this.inventory.isEmpty()) {
            this.chargeCapacitors = false;
            this.updateNextTick();
            return;
        }
        ItemStack itemStack = this.inventory.getItem(0);
        if (this.getRecipe(itemStack).isPresent()) {
            this.chargeCapacitors = true;
            this.updateNextTick();
            if (this.capacitorPercentage >= 200) {
                this.performRecipe((PolarizingRecipe)this.getRecipe(itemStack).get().value());
            }
        } else {
            this.chargeCapacitors = false;
            this.updateNextTick();
        }
    }

    @Override
    public float resistance() {
        return this.chargeCapacitors ? 30.0f : 0.0f;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.getPowerUsage() < 2000 && !this.inventory.isEmpty()) {
            TFMGTexts.Multimeter.notEnoughPower(2000.0).forGoggles(tooltip, 1);
            return true;
        }
        TFMGTexts.header("polarizer").style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
        TFMGTexts.Multimeter.charge((float)this.capacitorPercentage / 2.0f).forGoggles(tooltip);
        return true;
    }

    @Override
    public boolean canBeInGroups() {
        return false;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level.isClientSide) {
            this.angle.chase((double)(180.0f * ((float)this.capacitorPercentage / 200.0f)), (double)0.2f, LerpedFloat.Chaser.EXP);
            this.angle.tickChaser();
        }
        if (this.getPowerUsage() >= 2000 && this.chargeCapacitors) {
            if (this.capacitorPercentage < 200) {
                ++this.capacitorPercentage;
            } else {
                this.onInventoryChanged(this.inventory.getStackInSlot(0).getCount());
            }
        }
    }

    public void performRecipe(PolarizingRecipe recipe) {
        ItemStack stack = ((ProcessingOutput)recipe.getRollableResults().get(0)).rollOutput();
        this.inventory.setStackInSlot(0, stack);
        TFMGUtils.spawnElectricParticles(this.level, this.getBlockPos());
        this.capacitorPercentage = 0;
    }

    public Optional<RecipeHolder<PolarizingRecipe>> getRecipe(ItemStack item) {
        if (!this.hasLevel()) {
            return Optional.empty();
        }
        Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.level, (ItemStack)item, TFMGRecipeTypes.POLARIZING.getType(), PolarizingRecipe.class);
        if (assemblyRecipe.isPresent()) {
            return assemblyRecipe;
        }
        return TFMGRecipeTypes.POLARIZING.find(new RecipeWrapper((IItemHandler)this.inventory), this.level);
    }

    public int getItemChargingRate() {
        return (Integer)TFMGConfigs.common().machines.polarizerItemChargingRate.get();
    }

    @Override
    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
        compound.putInt("CapacitorPercentage", this.capacitorPercentage);
        compound.putBoolean("ChargeCapacitors", this.chargeCapacitors);
    }

    @Override
    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.inventory.deserializeNBT(registries, compound.getCompound("Inventory"));
        this.capacitorPercentage = compound.getInt("CapacitorPercentage");
        this.chargeCapacitors = compound.getBoolean("ChargeCapacitors");
    }
}

