/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.engines.engine_controller.packets;

import com.drmangotea.tfmg.content.engines.engine_controller.EngineControllerBlockEntity;
import com.drmangotea.tfmg.content.engines.engine_controller.packets.EngineControllerPacketBase;
import com.drmangotea.tfmg.registry.TFMGPackets;
import com.simibubi.create.content.redstone.link.RedstoneLinkNetworkHandler;
import com.simibubi.create.content.redstone.link.controller.LinkedControllerServerHandler;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.createmod.catnip.codecs.stream.CatnipStreamCodecBuilders;
import net.createmod.catnip.codecs.stream.CatnipStreamCodecs;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class EngineControllerInputPacket
extends EngineControllerPacketBase {
    public static final StreamCodec<ByteBuf, EngineControllerInputPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)CatnipStreamCodecBuilders.list((StreamCodec)ByteBufCodecs.INT), p -> p.activatedButtons, (StreamCodec)ByteBufCodecs.BOOL, p -> p.press, (StreamCodec)CatnipStreamCodecs.NULLABLE_BLOCK_POS, EngineControllerPacketBase::getControllerPos, EngineControllerInputPacket::new);
    private List<Integer> activatedButtons;
    private boolean press;

    public EngineControllerInputPacket(List<Integer> activatedButtons, boolean press) {
        this(activatedButtons, press, null);
    }

    public EngineControllerInputPacket(List<Integer> activatedButtons, boolean press, BlockPos lecternPos) {
        super(lecternPos);
        this.activatedButtons = activatedButtons;
        this.press = press;
    }

    @Override
    protected void handleItem(ServerPlayer player, ItemStack heldItem) {
    }

    @Override
    protected void handleLectern(ServerPlayer player, EngineControllerBlockEntity controller) {
        UUID uniqueID = player.getUUID();
        Level level = controller.getLevel();
        BlockPos pos = controller.getBlockPos();
        ArrayList<Couple<RedstoneLinkNetworkHandler.Frequency>> list = new ArrayList<Couple<RedstoneLinkNetworkHandler.Frequency>>();
        if (this.activatedButtons.contains(2)) {
            list.add(EngineControllerBlockEntity.toFrequency(controller, 0));
        }
        if (this.activatedButtons.contains(3)) {
            list.add(EngineControllerBlockEntity.toFrequency(controller, 1));
        }
        if (this.activatedButtons.contains(7)) {
            list.add(EngineControllerBlockEntity.toFrequency(controller, 2));
        }
        LinkedControllerServerHandler.receivePressed((LevelAccessor)level, (BlockPos)pos, (UUID)uniqueID, list, (boolean)this.press);
        controller.handleInput(this.activatedButtons, this.press);
    }

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return TFMGPackets.ENGINE_CONTROLLER_INPUT;
    }
}

