/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.engines.fuels;

import com.drmangotea.tfmg.TFMG;
import com.drmangotea.tfmg.content.engines.fuels.FuelType;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class EngineFuelTypeManager {
    public static final Map<ResourceLocation, FuelType> BUILTIN_TYPE_MAP = new HashMap<ResourceLocation, FuelType>();
    public static final Map<ResourceLocation, FuelType> CUSTOM_TYPE_MAP = new HashMap<ResourceLocation, FuelType>();
    public static final Map<ResourceLocation, FuelType> GLOBAL_TYPE_MAP = new HashMap<ResourceLocation, FuelType>();
    private static final Map<TagKey<Fluid>, FuelType> FLUID_TO_TYPE_MAP = new IdentityHashMap<TagKey<Fluid>, FuelType>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerBuiltinType(ResourceLocation id, FuelType type) {
        Map<ResourceLocation, FuelType> map = BUILTIN_TYPE_MAP;
        synchronized (map) {
            BUILTIN_TYPE_MAP.put(id, type);
        }
        map = GLOBAL_TYPE_MAP;
        synchronized (map) {
            GLOBAL_TYPE_MAP.put(id, type);
        }
    }

    public static FuelType getBuiltinType(ResourceLocation id) {
        return BUILTIN_TYPE_MAP.get(id);
    }

    public static FuelType getCustomType(ResourceLocation id) {
        return CUSTOM_TYPE_MAP.get(id);
    }

    public static FuelType getGlobalType(ResourceLocation id) {
        return GLOBAL_TYPE_MAP.get(id);
    }

    public static FuelType getTypeForFluid(Fluid fluid) {
        return FLUID_TO_TYPE_MAP.get(fluid);
    }

    public static Optional<FuelType> getTypeForStack(FluidStack fluidStack) {
        if (fluidStack.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(EngineFuelTypeManager.getTypeForFluid(fluidStack.getFluid()));
    }

    public static ResourceLocation getIdForType(FuelType type) {
        for (Map.Entry<ResourceLocation, FuelType> entry : GLOBAL_TYPE_MAP.entrySet()) {
            if (entry.getValue() != type) continue;
            return entry.getKey();
        }
        return null;
    }

    public static FuelType getTypeForId(ResourceLocation id) {
        for (Map.Entry<ResourceLocation, FuelType> entry : GLOBAL_TYPE_MAP.entrySet()) {
            if (!entry.getKey().equals((Object)id)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static void clear() {
        GLOBAL_TYPE_MAP.clear();
        CUSTOM_TYPE_MAP.clear();
        FLUID_TO_TYPE_MAP.clear();
    }

    public static void fillGlobalMap() {
        GLOBAL_TYPE_MAP.putAll(BUILTIN_TYPE_MAP);
        GLOBAL_TYPE_MAP.putAll(CUSTOM_TYPE_MAP);
        TFMG.LOGGER.info("Added {} Engine Fuel Types", (Object)GLOBAL_TYPE_MAP.size());
    }

    public static void toBuffer(FriendlyByteBuf buffer) {
        buffer.writeVarInt(CUSTOM_TYPE_MAP.size());
        for (Map.Entry<ResourceLocation, FuelType> entry : CUSTOM_TYPE_MAP.entrySet()) {
            buffer.writeResourceLocation(entry.getKey());
            FuelType.toBuffer(entry.getValue(), buffer);
        }
    }

    public static void fromBuffer(FriendlyByteBuf buffer) {
        EngineFuelTypeManager.clear();
        int size = buffer.readVarInt();
        for (int i = 0; i < size; ++i) {
            CUSTOM_TYPE_MAP.put(buffer.readResourceLocation(), FuelType.fromBuffer(buffer));
        }
        EngineFuelTypeManager.fillGlobalMap();
    }

    public static class ReloadListener
    extends SimpleJsonResourceReloadListener {
        private static final Gson GSON = new Gson();
        public static final ReloadListener INSTANCE = new ReloadListener();

        protected ReloadListener() {
            super(GSON, "tfmg_engine_fuels");
        }

        protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profiler) {
            EngineFuelTypeManager.clear();
            for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
                JsonElement element = entry.getValue();
                if (!element.isJsonObject()) continue;
                ResourceLocation id = entry.getKey();
                JsonObject object = element.getAsJsonObject();
                FuelType type = FuelType.fromJson(object);
                CUSTOM_TYPE_MAP.put(id, type);
            }
            EngineFuelTypeManager.fillGlobalMap();
        }
    }
}

