/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.engines.fuels;

import com.drmangotea.tfmg.content.engines.fuels.EngineFuelTypeManager;
import com.drmangotea.tfmg.registry.TFMGTags;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.simibubi.create.AllTags;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;

public class FuelType {
    TagKey<Fluid> fluid;
    private float speed;
    private float efficiency;
    private float stress;

    public FuelType() {
        this.fluid = TFMGTags.TFMGFluidTags.GASOLINE.tag;
        this.speed = 1.0f;
        this.efficiency = 1.0f;
        this.stress = 1.0f;
    }

    public TagKey<Fluid> getFluid() {
        return this.fluid;
    }

    public float getSpeed() {
        return this.speed;
    }

    public float getEfficiency() {
        return this.efficiency;
    }

    public float getStress() {
        return this.stress;
    }

    public static FuelType fromJson(JsonObject object) {
        FuelType type = new FuelType();
        try {
            FuelType.parseJsonPrimitive(object, "fluid", JsonPrimitive::isString, primitive -> {
                type.fluid = AllTags.optionalTag((Registry)BuiltInRegistries.FLUID, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"", (String)primitive.getAsString()));
            });
            FuelType.parseJsonPrimitive(object, "speed", JsonPrimitive::isNumber, primitive -> {
                type.speed = primitive.getAsFloat();
            });
            FuelType.parseJsonPrimitive(object, "efficiency", JsonPrimitive::isNumber, primitive -> {
                type.efficiency = primitive.getAsFloat();
            });
            FuelType.parseJsonPrimitive(object, "stress", JsonPrimitive::isNumber, primitive -> {
                type.stress = primitive.getAsFloat();
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return type;
    }

    private static void parseJsonPrimitive(JsonObject object, String key, Predicate<JsonPrimitive> predicate, Consumer<JsonPrimitive> consumer) {
        JsonPrimitive primitive;
        JsonElement element = object.get(key);
        if (element != null && element.isJsonPrimitive() && predicate.test(primitive = element.getAsJsonPrimitive())) {
            consumer.accept(primitive);
        }
    }

    public static void toBuffer(FuelType type, FriendlyByteBuf buffer) {
        buffer.writeResourceLocation(type.fluid.location());
        buffer.writeFloat(type.speed);
        buffer.writeFloat(type.efficiency);
        buffer.writeFloat(type.stress);
    }

    public static FuelType fromBuffer(FriendlyByteBuf buffer) {
        FuelType type = new FuelType();
        type.fluid = AllTags.optionalTag((Registry)BuiltInRegistries.FLUID, (ResourceLocation)buffer.readResourceLocation());
        type.speed = buffer.readFloat();
        type.efficiency = buffer.readFloat();
        type.stress = buffer.readFloat();
        return type;
    }

    public static class Builder {
        protected ResourceLocation id;
        protected FuelType result;

        public Builder(ResourceLocation id) {
            this.id = id;
            this.result = new FuelType();
        }

        public Builder speed(float speed) {
            this.result.speed = speed;
            return this;
        }

        public Builder efficiency(float efficiency) {
            this.result.efficiency = efficiency;
            return this;
        }

        public Builder stress(float stress) {
            this.result.stress = stress;
            return this;
        }

        public final Builder addFluids(TagKey<Fluid> tag) {
            this.result.fluid = tag;
            return this;
        }

        public FuelType register() {
            EngineFuelTypeManager.registerBuiltinType(this.id, this.result);
            return this.result;
        }

        public final FuelType registerAndAssign(TagKey<Fluid> tag) {
            this.addFluids(tag);
            this.register();
            return this.result;
        }
    }
}

