/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.engines.upgrades;

import com.drmangotea.tfmg.content.engines.types.AbstractSmallEngineBlockEntity;
import com.drmangotea.tfmg.content.engines.types.regular_engine.RegularEngineBlockEntity;
import com.drmangotea.tfmg.content.engines.upgrades.EngineUpgrade;
import com.drmangotea.tfmg.registry.TFMGItems;
import com.drmangotea.tfmg.registry.TFMGPartialModels;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.Optional;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TransmissionUpgrade
extends EngineUpgrade {
    @Override
    public Optional<? extends EngineUpgrade> createUpgrade() {
        return Optional.of(new TransmissionUpgrade());
    }

    @Override
    public void render(AbstractSmallEngineBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light) {
        BlockState state = be.getBlockState();
        Direction facing = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
        boolean side = false;
        ms.pushPose();
        if (be instanceof RegularEngineBlockEntity) {
            RegularEngineBlockEntity blockEntity = (RegularEngineBlockEntity)be;
            side = blockEntity.type.upgradesOnSide;
        }
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)TFMGPartialModels.TRANSMISSION, (BlockState)state).center()).translateY(side ? -0.125f : 0.0f)).rotateYDegrees(facing.toYRot())).rotateZDegrees(side ? 90.0f : 0.0f)).translateY(side ? 0.25f : 0.0f)).uncenter()).light(light).renderInto(ms, buffer.getBuffer(RenderType.solid()));
        ms.popPose();
    }

    @Override
    public Item getItem() {
        return TFMGItems.TRANSMISSION.asItem();
    }

    public static enum TransmissionState {
        REVERSE(0.9f, true),
        NEUTRAL(0.0f),
        SHIFT_1(0.6f),
        SHIFT_2(0.7f),
        SHIFT_3(1.1f),
        SHIFT_4(1.4f),
        SHIFT_5(1.5f),
        SHIFT_6(1.9f);

        public final float value;
        public final boolean reverse;
        public final String langKey;

        private TransmissionState(float value) {
            this(value, false);
        }

        private TransmissionState(float value, boolean reverse) {
            this.value = value;
            this.reverse = reverse;
            this.langKey = "engine.upgrade.transmission." + this.name().toLowerCase();
        }
    }
}

