/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.misc.winding_machine;

import com.drmangotea.tfmg.TFMG;
import com.drmangotea.tfmg.TFMGRegistries;
import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.base.blocks.WallMountBlock;
import com.drmangotea.tfmg.base.lang.TFMGLang;
import com.drmangotea.tfmg.content.electricity.connection.cable_type.CableType;
import com.drmangotea.tfmg.content.electricity.connection.cables.CableConnection;
import com.drmangotea.tfmg.content.electricity.connection.cables.CableConnectorBlockEntity;
import com.drmangotea.tfmg.content.machinery.misc.winding_machine.WindingMachineBlockEntity;
import com.drmangotea.tfmg.registry.TFMGDataComponents;
import com.drmangotea.tfmg.registry.TFMGItems;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class SpoolItem
extends Item {
    public final int barColor;
    public final ResourceLocation cableTypeKey;

    public SpoolItem(Item.Properties properties, int barColor, ResourceLocation cableTypeKey) {
        super(properties);
        this.barColor = barColor;
        this.cableTypeKey = cableTypeKey;
    }

    public void onCraftedBy(ItemStack stack, Level p_41448_, Player p_41449_) {
        stack.set(TFMGDataComponents.SPOOL_AMOUNT, (Object)1000);
        super.onCraftedBy(stack, p_41448_, p_41449_);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isCrouching() && (float)((Number)stack.getOrDefault(TFMGDataComponents.POSITION, (Object)Float.valueOf(0.0f))).longValue() != 0.0f) {
            BlockEntity blockEntity = level.getBlockEntity(BlockPos.of((long)((Number)stack.getOrDefault(TFMGDataComponents.POSITION, (Object)Float.valueOf(0.0f))).longValue()));
            if (blockEntity instanceof CableConnectorBlockEntity) {
                CableConnectorBlockEntity be = (CableConnectorBlockEntity)blockEntity;
                be.player = null;
            }
            stack.set(TFMGDataComponents.POSITION, (Object)0L);
            stack.remove(TFMGDataComponents.POSITION);
            stack.remove(TFMGDataComponents.X_POS);
            stack.remove(TFMGDataComponents.Y_POS);
            stack.remove(TFMGDataComponents.Z_POS);
            if (level.isClientSide) {
                player.displayClientMessage((Component)TFMGLang.translateDirect("wires.removed_data", new Object[0]).withStyle(ChatFormatting.YELLOW), true);
            }
            return InteractionResultHolder.success((Object)stack);
        }
        return super.use(level, player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)TFMGLang.translateDirect("tooltip.coils", stack.get(TFMGDataComponents.SPOOL_AMOUNT) == null ? Integer.valueOf(0) : stack.get(TFMGDataComponents.SPOOL_AMOUNT)).withStyle(ChatFormatting.GREEN));
        if (stack.get(TFMGDataComponents.POSITION) == null) {
            return;
        }
        BlockPos pos = BlockPos.of((long)((Long)stack.get(TFMGDataComponents.POSITION)));
        if (pos.asLong() != 0L) {
            tooltip.add((Component)TFMGLang.text(pos.getX() + " " + pos.getY() + " " + pos.getZ()).component().withStyle(ChatFormatting.AQUA));
        }
        super.appendHoverText(stack, context, tooltip, flag);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof WindingMachineBlockEntity) {
            WindingMachineBlockEntity be = (WindingMachineBlockEntity)blockEntity;
            ItemStack oldSpool = ItemStack.EMPTY;
            if (!be.spool.isEmpty()) {
                oldSpool = be.spool;
            }
            be.spool = context.getItemInHand();
            context.getPlayer().setItemInHand(context.getHand(), oldSpool);
            be.sendData();
            be.setChanged();
            return InteractionResult.SUCCESS;
        }
        if (stack.get(TFMGDataComponents.SPOOL_AMOUNT) == null) {
            return InteractionResult.PASS;
        }
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (Objects.equals(this.cableTypeKey, TFMG.asResource("empty"))) {
            return InteractionResult.PASS;
        }
        Direction direction = (Direction)level.getBlockState(pos).getValue((Property)WallMountBlock.FACING);
        for (int i = 0; i < 64 && level.getBlockEntity(pos.relative(direction)) instanceof CableConnectorBlockEntity; ++i) {
            pos = pos.relative(direction);
        }
        BlockEntity blockEntity2 = level.getBlockEntity(pos);
        if (blockEntity2 instanceof CableConnectorBlockEntity) {
            CableConnectorBlockEntity be = (CableConnectorBlockEntity)blockEntity2;
            if (stack.get(TFMGDataComponents.POSITION) != null) {
                BlockPos posToConnect = BlockPos.of((long)((Long)stack.get(TFMGDataComponents.POSITION)));
                if (posToConnect.equals((Object)pos)) {
                    stack.set(TFMGDataComponents.POSITION, (Object)0L);
                    if (level.isClientSide) {
                        player.displayClientMessage((Component)TFMGLang.translateDirect("wires.cant_connect_itself", new Object[0]).withStyle(ChatFormatting.YELLOW), true);
                    }
                    be.player = null;
                    be.sendData();
                    be.setChanged();
                    return InteractionResult.SUCCESS;
                }
                for (int i = 0; i < 64 && level.getBlockEntity(posToConnect.relative(direction)) instanceof CableConnectorBlockEntity; ++i) {
                    posToConnect = posToConnect.relative(direction);
                }
                BlockEntity blockEntity3 = level.getBlockEntity(posToConnect);
                if (blockEntity3 instanceof CableConnectorBlockEntity) {
                    CableConnectorBlockEntity otherBE = (CableConnectorBlockEntity)blockEntity3;
                    CableType cableType = TFMGUtils.getCableType(this.cableTypeKey);
                    CableConnection connection1 = new CableConnection(be.getCablePosition(), otherBE.getCablePosition(), otherBE.getBlockPos(), cableType, true);
                    CableConnection connection2 = new CableConnection(otherBE.getCablePosition(), be.getCablePosition(), be.getBlockPos(), cableType, false);
                    float wireCost = connection1.getLength() / 8.0f;
                    if ((float)((Integer)stack.get(TFMGDataComponents.SPOOL_AMOUNT)).intValue() < wireCost * 125.0f) {
                        return InteractionResult.PASS;
                    }
                    if (be.connections.contains(connection1) || otherBE.connections.contains(connection1)) {
                        if (level.isClientSide) {
                            player.displayClientMessage((Component)TFMGLang.translateDirect("wires.connection_already_created", new Object[0]).withStyle(ChatFormatting.YELLOW), true);
                        }
                        be.player = null;
                        be.sendData();
                        be.setChanged();
                        return InteractionResult.SUCCESS;
                    }
                    be.connections.add(connection1);
                    otherBE.connections.add(connection2);
                    be.onPlaced();
                    stack.set(TFMGDataComponents.SPOOL_AMOUNT, (Object)((int)((float)((Integer)stack.get(TFMGDataComponents.SPOOL_AMOUNT)).intValue() - wireCost * 125.0f)));
                    be.player = null;
                    otherBE.player = null;
                    be.setChanged();
                    otherBE.setChanged();
                    be.sendData();
                    otherBE.sendData();
                    stack.remove(TFMGDataComponents.POSITION);
                    stack.remove(TFMGDataComponents.X_POS);
                    stack.remove(TFMGDataComponents.Y_POS);
                    stack.remove(TFMGDataComponents.Z_POS);
                }
                be.player = null;
                return InteractionResult.SUCCESS;
            }
            stack.set(TFMGDataComponents.POSITION, (Object)be.getBlockPos().asLong());
            stack.set(TFMGDataComponents.X_POS, (Object)((int)be.getCablePosition().x()));
            stack.set(TFMGDataComponents.Y_POS, (Object)((int)be.getCablePosition().y()));
            stack.set(TFMGDataComponents.Z_POS, (Object)((int)be.getCablePosition().z()));
            be.player = player;
            be.color = this.barColor;
            be.sendData();
            be.setChanged();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void removeOtherConnections(Player player, ItemStack stack) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack itemStack = player.getInventory().getItem(i);
        }
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean p_41408_) {
        super.inventoryTick(stack, level, entity, slot, p_41408_);
        if (stack.get(TFMGDataComponents.SPOOL_AMOUNT) == null) {
            return;
        }
        if ((Integer)stack.get(TFMGDataComponents.SPOOL_AMOUNT) == 0 && entity instanceof Player) {
            Player player = (Player)entity;
            if (!stack.is((Item)TFMGItems.EMPTY_SPOOL.get())) {
                player.getInventory().setItem(slot, TFMGItems.EMPTY_SPOOL.asStack());
            }
        }
    }

    public boolean isBarVisible(ItemStack stack) {
        return !Objects.equals(this.cableTypeKey, TFMG.asResource("empty")) && TFMGRegistries.CABLE_TYPE_REGISTRY.containsKey(this.cableTypeKey);
    }

    public int getBarColor(ItemStack stack) {
        return this.barColor;
    }

    public int getBarWidth(ItemStack stack) {
        if (stack.get(TFMGDataComponents.SPOOL_AMOUNT) == null) {
            return 13;
        }
        return (int)(13.0f * ((float)((Integer)stack.get(TFMGDataComponents.SPOOL_AMOUNT)).intValue() / 1000.0f));
    }
}

