/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.oil_processing.pumpjack.base;

import com.drmangotea.tfmg.TFMG;
import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.base.lang.TFMGTexts;
import com.drmangotea.tfmg.config.TFMGConfigs;
import com.drmangotea.tfmg.content.machinery.oil_processing.pumpjack.base.TestSavedDataManager;
import com.drmangotea.tfmg.content.machinery.oil_processing.pumpjack.crank.PumpjackCrankBlockEntity;
import com.drmangotea.tfmg.content.machinery.oil_processing.pumpjack.hammer.PumpjackBlockEntity;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.drmangotea.tfmg.registry.TFMGFluids;
import com.drmangotea.tfmg.registry.TFMGTags;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class PumpjackBaseBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public PumpjackBlockEntity controllerHammer;
    public boolean isRunning = false;
    int depositCheckTimer = 0;
    public int miningRate = 0;
    protected IFluidHandler fluidCapability;
    public FluidTank tank = this.createInventory();
    public BlockPos deposit;

    public PumpjackBaseBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.fluidCapability = this.tank;
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)TFMGBlockEntities.PUMPJACK_BASE.get(), (be, context) -> be.fluidCapability);
    }

    public void tick() {
        super.tick();
        if (this.controllerHammer != null && !(this.level.getBlockEntity(this.controllerHammer.getBlockPos()) instanceof PumpjackBlockEntity)) {
            this.controllerHammer = null;
        }
        if (this.controllerHammer != null && this.controllerHammer.base == null) {
            this.controllerHammer = null;
        }
        if (this.controllerHammer != null && !this.controllerHammer.isRunning()) {
            this.controllerHammer = null;
        }
        if (this.controllerHammer == null) {
            return;
        }
        this.isRunning = this.controllerHammer.isRunning();
        if (!this.isRunning) {
            this.deposit = null;
            this.controllerHammer = null;
            this.miningRate = 0;
            return;
        }
        ++this.depositCheckTimer;
        if (this.depositCheckTimer > 50) {
            this.depositCheckTimer = 0;
            this.findDeposit();
        }
        PumpjackCrankBlockEntity crank = null;
        if (this.controllerHammer.crank != null) {
            crank = this.controllerHammer.crank;
        }
        if (crank == null) {
            return;
        }
        this.miningRate = (int)Math.abs(crank.getMachineInputSpeed() * crank.heightModifier);
        this.process();
    }

    public void lazyTick() {
        super.lazyTick();
    }

    public void findDeposit() {
        for (int i = 0; i < this.getBlockPos().getY() + 64; ++i) {
            BlockPos checkedPos = new BlockPos(this.getBlockPos().getX(), this.getBlockPos().getY() - 1 - i, this.getBlockPos().getZ());
            if (this.level.getBlockState(new BlockPos((Vec3i)checkedPos)).is((Block)TFMGBlocks.OIL_DEPOSIT.get())) {
                this.deposit = checkedPos;
                return;
            }
            if (this.level.getBlockState(new BlockPos((Vec3i)checkedPos)).is(TFMGTags.TFMGBlockTags.INDUSTRIAL_PIPE.tag)) continue;
            this.deposit = null;
            return;
        }
        this.deposit = null;
    }

    public void process() {
        if (this.deposit == null) {
            return;
        }
        if (!this.level.isClientSide) {
            if (!TestSavedDataManager.containsDeposit(this.deposit.asLong())) {
                TFMG.DEPOSITS.addDeposit(this.level, this.deposit.asLong());
                TFMG.DEPOSITS.markDirty();
                this.sendData();
            }
        }
        if (this.tank.getFluidAmount() + this.miningRate > this.tank.getCapacity()) {
            return;
        }
        int amountPumped = this.tank.fill(new FluidStack(((BaseFlowingFluid.Flowing)TFMGFluids.CRUDE_OIL.get()).getSource(), this.miningRate), IFluidHandler.FluidAction.EXECUTE);
        this.sendData();
        if (amountPumped == 0) {
            return;
        }
        if (((Boolean)TFMGConfigs.common().worldgen.infiniteDeposits.get()).booleanValue()) {
            return;
        }
        RandomSource randomSource = this.level.getRandom();
    }

    public void setControllerHammer(PumpjackBlockEntity controllerHammer) {
        this.controllerHammer = controllerHammer;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected SmartFluidTank createInventory() {
        return new SmartFluidTank(this, 8000, this::onFluidStackChanged){

            public boolean isFluidValid(FluidStack stack) {
                return stack.getFluid().isSame((Fluid)TFMGFluids.CRUDE_OIL.getSource());
            }
        };
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        this.sendData();
        this.setChanged();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        TFMGTexts.header("pumpjack").forGoggles(tooltip);
        if (this.deposit == null) {
            TFMGTexts.invalidMachine().forGoggles(tooltip, 1);
        }
        TFMGUtils.createFluidTooltip((BlockEntity)this, tooltip);
        return true;
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.tank.readFromNBT(registries, compound.getCompound("TankContent"));
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.put("TankContent", (Tag)this.tank.writeToNBT(registries, new CompoundTag()));
        super.write(compound, registries, clientPacket);
    }
}

