/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.oil_processing.pumpjack.hammer;

import com.drmangotea.tfmg.content.machinery.oil_processing.pumpjack.base.PumpjackBaseBlockEntity;
import com.drmangotea.tfmg.content.machinery.oil_processing.pumpjack.crank.PumpjackCrankBlockEntity;
import com.drmangotea.tfmg.content.machinery.oil_processing.pumpjack.hammer.PumpjackBlock;
import com.drmangotea.tfmg.content.machinery.oil_processing.pumpjack.hammer.PumpjackContraption;
import com.drmangotea.tfmg.registry.TFMGTags;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.IControlContraption;
import com.simibubi.create.content.contraptions.IDisplayAssemblyExceptions;
import com.simibubi.create.content.contraptions.bearing.BearingBlock;
import com.simibubi.create.content.contraptions.bearing.IBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.transmission.sequencer.SequencerInstructions;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import java.util.List;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;

public class PumpjackBlockEntity
extends GeneratingKineticBlockEntity
implements IBearingBlockEntity,
IDisplayAssemblyExceptions {
    protected ControlledContraptionEntity movedContraption;
    protected float angle;
    protected boolean running;
    protected boolean assembleNextTick;
    protected float clientAngleDiff;
    protected AssemblyException lastException;
    protected double sequencedAngleLimit;
    private float prevAngle;
    public BlockPos headPosition = null;
    public BlockPos connectorPosition = null;
    public PumpjackCrankBlockEntity crank = null;
    public PumpjackBaseBlockEntity base = null;
    public int connectorDistance = 0;
    public int headDistance = 0;
    public boolean connectorAtFront = false;
    public boolean headAtFront = false;
    public int crankConnectorDistance = 0;
    public int headBaseDistance = 0;

    public PumpjackBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(3);
        this.sequencedAngleLimit = -1.0;
    }

    public boolean isWoodenTop() {
        return false;
    }

    protected boolean syncSequenceContext() {
        return true;
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().inflate(7.0);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.registerAwardables(behaviours, new CreateAdvancement[]{AllAdvancements.CONTRAPTION_ACTORS});
    }

    public void remove() {
        if (!this.level.isClientSide) {
            this.disassemble();
        }
        super.remove();
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        if (this.connectorPosition != null) {
            compound.putInt("connectorX", this.connectorPosition.getX());
            compound.putInt("connectorY", this.connectorPosition.getY());
            compound.putInt("connectorZ", this.connectorPosition.getZ());
        }
        if (this.headPosition != null) {
            compound.putInt("headX", this.headPosition.getX());
            compound.putInt("headY", this.headPosition.getY());
            compound.putInt("headZ", this.headPosition.getZ());
        }
        compound.putBoolean("connectorAtFront", this.connectorAtFront);
        compound.putBoolean("headAtFront", this.headAtFront);
        compound.putBoolean("Running", this.running);
        compound.putFloat("Angle", this.angle);
        if (this.sequencedAngleLimit >= 0.0) {
            compound.putDouble("SequencedAngleLimit", this.sequencedAngleLimit);
        }
        AssemblyException.write((CompoundTag)compound, (HolderLookup.Provider)registries, (AssemblyException)this.lastException);
        super.write(compound, registries, clientPacket);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        if (this.wasMoved) {
            super.read(compound, registries, clientPacket);
            return;
        }
        this.connectorPosition = new BlockPos(compound.getInt("connectorX"), compound.getInt("connectorY"), compound.getInt("connectorZ"));
        this.headPosition = new BlockPos(compound.getInt("headX"), compound.getInt("headY"), compound.getInt("headZ"));
        this.connectorAtFront = compound.getBoolean("connectorAtFront");
        this.headAtFront = compound.getBoolean("headAtFront");
        float angleBefore = this.angle;
        this.running = compound.getBoolean("Running");
        this.angle = compound.getFloat("Angle");
        this.sequencedAngleLimit = compound.contains("SequencedAngleLimit") ? compound.getDouble("SequencedAngleLimit") : -1.0;
        this.lastException = AssemblyException.read((CompoundTag)compound, (HolderLookup.Provider)registries);
        super.read(compound, registries, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (this.running) {
            if (this.movedContraption == null || !this.movedContraption.isStalled()) {
                this.clientAngleDiff = AngleHelper.getShortestAngleDiff((double)angleBefore, (double)this.angle);
                this.angle = angleBefore;
            }
        } else {
            this.movedContraption = null;
        }
    }

    public float getInterpolatedAngle(float partialTicks) {
        if (this.isVirtual()) {
            return Mth.lerp((float)(partialTicks + 0.5f), (float)this.prevAngle, (float)this.angle);
        }
        if (this.movedContraption == null || this.movedContraption.isStalled() || !this.running) {
            partialTicks = 0.0f;
        }
        float angularSpeed = this.getAngularSpeed();
        if (this.sequencedAngleLimit >= 0.0) {
            angularSpeed = (float)Mth.clamp((double)angularSpeed, (double)(-this.sequencedAngleLimit), (double)this.sequencedAngleLimit);
        }
        return Mth.lerp((float)partialTicks, (float)this.angle, (float)(this.angle + angularSpeed));
    }

    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        this.assembleNextTick = true;
        this.sequencedAngleLimit = -1.0;
        if (this.movedContraption != null && Math.signum(prevSpeed) != Math.signum(this.getSpeed()) && prevSpeed != 0.0f) {
            if (!this.movedContraption.isStalled()) {
                this.angle = Math.round(this.angle);
                this.applyRotation();
            }
            this.movedContraption.getContraption().stop(this.level);
        }
        if (this.sequenceContext != null && this.sequenceContext.instruction() == SequencerInstructions.TURN_ANGLE) {
            this.sequencedAngleLimit = this.sequenceContext.getEffectiveValue((double)this.getTheoreticalSpeed());
        }
    }

    public float getAngularSpeed() {
        float speed = PumpjackBlockEntity.convertToAngular((float)this.getSpeed());
        if (this.getSpeed() == 0.0f) {
            speed = 0.0f;
        }
        if (this.level.isClientSide) {
            speed *= ServerSpeedProvider.get();
            speed += this.clientAngleDiff / 3.0f;
        }
        return speed;
    }

    public AssemblyException getLastAssemblyException() {
        return this.lastException;
    }

    public BlockPos getBlockPosition() {
        return this.worldPosition;
    }

    public void assemble() {
        if (!(this.level.getBlockState(this.worldPosition).getBlock() instanceof BearingBlock)) {
            return;
        }
        Direction direction = (Direction)this.getBlockState().getValue((Property)BearingBlock.FACING);
        PumpjackContraption contraption = new PumpjackContraption(direction);
        try {
            if (!contraption.assemble(this.level, this.worldPosition)) {
                return;
            }
            if (this.connectorPosition == null || this.headPosition == null) {
                return;
            }
            this.lastException = null;
        }
        catch (AssemblyException e) {
            this.lastException = e;
            this.sendData();
            return;
        }
        int q = 1;
        if (direction.getAxis() == Direction.Axis.X) {
            q = -1;
        }
        boolean canAssemble = true;
        boolean foundHead = false;
        boolean foundConnector = false;
        BlockPos headLocalPos = this.headPosition.subtract((Vec3i)this.getBlockPos().above());
        for (Object block : contraption.getBlocks().values()) {
            if (!block.state().is(TFMGTags.TFMGBlockTags.PUMPJACK_HEAD.tag)) continue;
            foundHead = true;
            if (block.pos().getX() == headLocalPos.getX() && block.pos().getY() == q * headLocalPos.getY() && block.pos().getZ() == q * headLocalPos.getZ()) continue;
            canAssemble = false;
        }
        BlockPos connectorLocalPos = this.connectorPosition.subtract((Vec3i)this.getBlockPos().above());
        for (StructureTemplate.StructureBlockInfo block : contraption.getBlocks().values()) {
            if (!block.state().is(TFMGTags.TFMGBlockTags.PUMPJACK_CONNECTOR.tag)) continue;
            foundConnector = true;
            if (block.pos().getX() == connectorLocalPos.getX() && block.pos().getY() == q * connectorLocalPos.getY() && block.pos().getZ() == q * connectorLocalPos.getZ()) continue;
            canAssemble = false;
        }
        if (!(canAssemble && foundHead && foundConnector)) {
            return;
        }
        if (this.base.controllerHammer != this && this.base.controllerHammer != null) {
            return;
        }
        contraption.removeBlocksFromWorld(this.level, BlockPos.ZERO);
        this.movedContraption = ControlledContraptionEntity.create((Level)this.level, (IControlContraption)this, (Contraption)contraption);
        BlockPos anchor = this.worldPosition.above();
        this.movedContraption.setPos((double)anchor.getX(), (double)anchor.getY(), (double)anchor.getZ());
        this.movedContraption.setRotationAxis(direction.getClockWise().getAxis());
        this.level.addFreshEntity((Entity)this.movedContraption);
        AllSoundEvents.MECHANICAL_PRESS_ACTIVATION.playOnServer(this.level, (Vec3i)this.worldPosition);
        if (contraption.containsBlockBreakers()) {
            this.award(AllAdvancements.CONTRAPTION_ACTORS);
        }
        this.running = true;
        this.angle = 0.0f;
        this.sendData();
        this.updateGeneratedRotation();
    }

    public boolean isHead(BlockPos pos) {
        return this.level.getBlockState(pos).is(TFMGTags.TFMGBlockTags.PUMPJACK_HEAD.tag);
    }

    public boolean isPart(BlockPos pos) {
        return this.level.getBlockState(pos).is(TFMGTags.TFMGBlockTags.PUMPJACK_PART.tag);
    }

    public boolean isConnector(BlockPos pos) {
        return this.level.getBlockState(pos).is(TFMGTags.TFMGBlockTags.PUMPJACK_CONNECTOR.tag);
    }

    private boolean findHeadAndConnector() {
        int i;
        Direction direction = (Direction)this.getBlockState().getValue((Property)DirectionalBlock.FACING);
        BlockPos checkedPos = this.getBlockPos().above();
        this.connectorPosition = null;
        this.headPosition = null;
        for (i = 0; i < 7; ++i) {
            if (this.connectorPosition != null && this.headPosition != null) {
                this.sendData();
                return true;
            }
            if (i != 0 && this.isHead(checkedPos)) {
                this.headPosition = checkedPos;
                this.headAtFront = true;
                checkedPos = checkedPos.relative(direction);
                this.sendData();
                continue;
            }
            if (i != 0 && this.isConnector(checkedPos) && ((Direction)this.level.getBlockState(checkedPos).getValue((Property)HorizontalDirectionalBlock.FACING)).getAxis() == ((Direction)this.getBlockState().getValue((Property)DirectionalBlock.FACING)).getAxis()) {
                this.connectorPosition = checkedPos;
                this.connectorAtFront = true;
                checkedPos = checkedPos.relative(direction);
                this.sendData();
                continue;
            }
            if (!this.isPart(checkedPos) || ((Direction)this.level.getBlockState(checkedPos).getValue((Property)HorizontalDirectionalBlock.FACING)).getAxis() != ((Direction)this.getBlockState().getValue((Property)DirectionalBlock.FACING)).getAxis()) break;
            checkedPos = checkedPos.relative(direction);
        }
        checkedPos = this.getBlockPos().above();
        for (i = 0; i < 7; ++i) {
            if (this.connectorPosition != null && this.headPosition != null) {
                this.sendData();
                return true;
            }
            if (i != 0 && this.isHead(checkedPos)) {
                this.headPosition = checkedPos;
                this.headAtFront = false;
                checkedPos = checkedPos.relative(direction.getOpposite());
                this.sendData();
                continue;
            }
            if (i != 0 && this.isConnector(checkedPos) && ((Direction)this.level.getBlockState(checkedPos).getValue((Property)HorizontalDirectionalBlock.FACING)).getAxis() == ((Direction)this.getBlockState().getValue((Property)DirectionalBlock.FACING)).getAxis()) {
                this.connectorPosition = checkedPos;
                this.connectorAtFront = false;
                checkedPos = checkedPos.relative(direction.getOpposite());
                this.sendData();
                continue;
            }
            if (!this.isPart(checkedPos) || ((Direction)this.level.getBlockState(checkedPos).getValue((Property)HorizontalDirectionalBlock.FACING)).getAxis() != ((Direction)this.getBlockState().getValue((Property)DirectionalBlock.FACING)).getAxis()) break;
            checkedPos = checkedPos.relative(direction.getOpposite());
        }
        this.sendData();
        return false;
    }

    public void disassemble() {
        if (!this.running && this.movedContraption == null) {
            return;
        }
        this.connectorDistance = 0;
        this.headDistance = 0;
        this.angle = 0.0f;
        this.sequencedAngleLimit = -1.0;
        if (this.movedContraption != null) {
            this.movedContraption.disassemble();
            AllSoundEvents.MECHANICAL_PRESS_ACTIVATION.playOnServer(this.level, (Vec3i)this.worldPosition);
        }
        this.movedContraption = null;
        this.running = false;
        this.updateGeneratedRotation();
        this.assembleNextTick = false;
        this.sendData();
    }

    public void tick() {
        super.tick();
        if (!this.isRunning()) {
            this.findHeadAndConnector();
        }
        if (!this.isRunning() && this.isComplete() && !this.level.isClientSide) {
            this.assemble();
        }
        if (this.base != null && this.base.controllerHammer == null && this.isRunning()) {
            this.base.setControllerHammer(this);
        }
        if (!this.isComplete() && !this.level.isClientSide) {
            this.disassemble();
        }
        this.setHolderSize();
        Direction direction = (Direction)this.getBlockState().getValue((Property)BearingBlock.FACING);
        if (this.connectorPosition != null) {
            if (direction.getAxis() == Direction.Axis.Z) {
                this.connectorDistance = Math.abs(this.getBlockPos().getZ() - this.connectorPosition.getZ());
            }
            if (direction.getAxis() == Direction.Axis.X) {
                this.connectorDistance = Math.abs(this.getBlockPos().getX() - this.connectorPosition.getX());
            }
            if (this.crank != null) {
                this.crankConnectorDistance = Math.abs(this.crank.getBlockPos().getY() - this.connectorPosition.getY());
                this.crank.crankRadius = (float)this.connectorDistance / 5.0f;
            }
        }
        if (this.headPosition != null) {
            if (direction.getAxis() == Direction.Axis.Z) {
                this.headDistance = Math.abs(this.getBlockPos().getZ() - this.headPosition.getZ());
            }
            if (direction.getAxis() == Direction.Axis.X) {
                this.headDistance = Math.abs(this.getBlockPos().getX() - this.headPosition.getX());
            }
            if (this.base != null) {
                this.headBaseDistance = Math.abs(this.base.getBlockPos().getY() - this.headPosition.getY());
            }
        }
        if (this.connectorPosition != null) {
            this.crank = this.findCrank();
        }
        if (this.crank != null && !(this.level.getBlockEntity(this.crank.getBlockPos()) instanceof PumpjackCrankBlockEntity)) {
            this.crank = null;
        }
        if (this.headPosition != null) {
            this.base = this.findBase();
        }
        if (this.base != null && !(this.level.getBlockEntity(this.base.getBlockPos()) instanceof PumpjackBaseBlockEntity)) {
            this.base = null;
        }
        this.prevAngle = this.angle;
        if (this.level.isClientSide) {
            this.clientAngleDiff /= 2.0f;
        }
        if (!this.level.isClientSide && this.assembleNextTick) {
            this.assembleNextTick = false;
            if (!this.running) {
                this.assemble();
            }
        }
        if (!this.running) {
            return;
        }
        if (!(this.movedContraption != null && this.movedContraption.isStalled() || this.crank == null)) {
            int x = 1;
            if (this.connectorAtFront) {
                x = -1;
            }
            this.angle = direction == Direction.SOUTH || direction == Direction.WEST ? (float)Math.toDegrees(Math.atan(this.crank.heightModifier * (float)x / (float)this.connectorDistance)) : (float)Math.toDegrees(Math.atan(-this.crank.heightModifier * (float)x / (float)this.connectorDistance));
        }
        this.applyRotation();
    }

    public void setHolderSize() {
        if (this.isRunning()) {
            return;
        }
        if (!this.level.getBlockState(this.getBlockPos().above()).is(TFMGTags.TFMGBlockTags.PUMPJACK_SMALL_PART.tag) && !((Boolean)this.getBlockState().getValue((Property)PumpjackBlock.WIDE)).booleanValue()) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)PumpjackBlock.WIDE, (Comparable)Boolean.valueOf(true)), 2);
        }
        if (this.level.getBlockState(this.getBlockPos().above()).is(TFMGTags.TFMGBlockTags.PUMPJACK_SMALL_PART.tag) && ((Boolean)this.getBlockState().getValue((Property)PumpjackBlock.WIDE)).booleanValue()) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)PumpjackBlock.WIDE, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public boolean isComplete() {
        return this.base != null && this.crank != null;
    }

    private PumpjackCrankBlockEntity findCrank() {
        BlockPos checkedPos = this.connectorPosition.below();
        for (int i = 0; i < 7; ++i) {
            if (this.level.getBlockEntity(checkedPos) instanceof PumpjackCrankBlockEntity && ((Direction)this.level.getBlockState(checkedPos).getValue((Property)HorizontalDirectionalBlock.FACING)).getAxis() == ((Direction)this.getBlockState().getValue((Property)DirectionalBlock.FACING)).getAxis()) {
                return (PumpjackCrankBlockEntity)this.level.getBlockEntity(checkedPos);
            }
            checkedPos = checkedPos.below();
        }
        return null;
    }

    private PumpjackBaseBlockEntity findBase() {
        BlockPos checkedPos = this.headPosition.below();
        for (int i = 0; i < 8; ++i) {
            if (this.level.getBlockEntity(checkedPos) instanceof PumpjackBaseBlockEntity) {
                return (PumpjackBaseBlockEntity)this.level.getBlockEntity(checkedPos);
            }
            checkedPos = checkedPos.below();
        }
        return null;
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.movedContraption != null && !this.level.isClientSide) {
            this.sendData();
        }
    }

    protected void applyRotation() {
        if (this.movedContraption == null) {
            return;
        }
        this.movedContraption.setAngle(this.angle);
        BlockState blockState = this.getBlockState();
        if (blockState.hasProperty((Property)BlockStateProperties.FACING)) {
            this.movedContraption.setRotationAxis(((Direction)blockState.getValue((Property)BlockStateProperties.FACING)).getClockWise().getAxis());
        }
    }

    public void attach(ControlledContraptionEntity contraption) {
        BlockState blockState = this.getBlockState();
        if (!(contraption.getContraption() instanceof PumpjackContraption)) {
            return;
        }
        if (!blockState.hasProperty((Property)BearingBlock.FACING)) {
            return;
        }
        this.movedContraption = contraption;
        this.setChanged();
        BlockPos anchor = this.worldPosition.above();
        this.movedContraption.setPos((double)anchor.getX(), (double)anchor.getY(), (double)anchor.getZ());
        if (!this.level.isClientSide) {
            this.running = true;
            this.sendData();
        }
    }

    public void onStall() {
        if (!this.level.isClientSide) {
            this.sendData();
        }
    }

    public boolean isValid() {
        return !this.isRemoved();
    }

    public boolean isAttachedTo(AbstractContraptionEntity contraption) {
        return this.movedContraption == contraption;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setAngle(float forcedAngle) {
        this.angle = forcedAngle;
    }
}

