/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.recipes;

import com.drmangotea.tfmg.recipes.IndustrialBlastingRecipeParams;
import com.drmangotea.tfmg.registry.TFMGRecipeTypes;
import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeParams;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

public class IndustrialBlastingRecipe
extends ProcessingRecipe<RecipeInput, IndustrialBlastingRecipeParams> {
    public int hotAirUsage;

    public IndustrialBlastingRecipe(IndustrialBlastingRecipeParams params) {
        super((IRecipeTypeInfo)TFMGRecipeTypes.INDUSTRIAL_BLASTING, (ProcessingRecipeParams)params);
        this.hotAirUsage = params.hotAirUsage;
    }

    protected int getMaxInputCount() {
        return 2;
    }

    protected boolean canSpecifyDuration() {
        return true;
    }

    protected int getMaxOutputCount() {
        return 0;
    }

    protected int getMaxFluidOutputCount() {
        return 3;
    }

    public FluidStack getPrimaryResult() {
        return (FluidStack)this.getFluidResults().get(0);
    }

    public FluidStack getSecondaryResult() {
        return (FluidStack)this.getFluidResults().get(1);
    }

    public FluidStack getGasByproduct() {
        if (this.getFluidResults().size() == 3) {
            return (FluidStack)this.getFluidResults().get(2);
        }
        return FluidStack.EMPTY;
    }

    public boolean matches(RecipeInput inv, Level worldIn) {
        if (inv.isEmpty()) {
            return false;
        }
        return ((Ingredient)this.ingredients.get(0)).test(inv.getItem(0));
    }

    public static class Serializer<R extends IndustrialBlastingRecipe>
    implements RecipeSerializer<R> {
        private final MapCodec<R> codec;
        private final StreamCodec<RegistryFriendlyByteBuf, R> streamCodec;

        public Serializer(ProcessingRecipe.Factory<IndustrialBlastingRecipeParams, R> factory) {
            this.codec = ProcessingRecipe.codec(factory, IndustrialBlastingRecipeParams.CODEC);
            this.streamCodec = ProcessingRecipe.streamCodec(factory, IndustrialBlastingRecipeParams.STREAM_CODEC);
        }

        public MapCodec<R> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, R> streamCodec() {
            return this.streamCodec;
        }
    }

    public static class Builder<R extends IndustrialBlastingRecipe>
    extends ProcessingRecipeBuilder<IndustrialBlastingRecipeParams, R, Builder<R>> {
        public Builder(Factory<R> factory, ResourceLocation recipeId) {
            super(factory, recipeId);
        }

        protected IndustrialBlastingRecipeParams createParams() {
            return new IndustrialBlastingRecipeParams();
        }

        public Builder<R> self() {
            return this;
        }

        public Builder<R> hotAirUsage(int value) {
            ((IndustrialBlastingRecipeParams)this.params).hotAirUsage = value;
            return this;
        }
    }

    @FunctionalInterface
    public static interface Factory<R extends IndustrialBlastingRecipe>
    extends ProcessingRecipe.Factory<IndustrialBlastingRecipeParams, R> {
        public R create(IndustrialBlastingRecipeParams var1);
    }
}

