/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.client.gui.SortButtonsPosition;
import net.p3pp3rf1y.sophisticatedcore.util.RegistryHelper;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final Client CLIENT;
    public static final ModConfigSpec CLIENT_SPEC;
    public static final Common COMMON;
    public static final ModConfigSpec COMMON_SPEC;

    private Config() {
    }

    static {
        Pair clientSpec = new ModConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ModConfigSpec)clientSpec.getRight();
        CLIENT = (Client)clientSpec.getLeft();
        Pair commonSpec = new ModConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ModConfigSpec)commonSpec.getRight();
        COMMON = (Common)commonSpec.getLeft();
    }

    public static class Client {
        public final ModConfigSpec.EnumValue<SortButtonsPosition> sortButtonsPosition;
        public final ModConfigSpec.BooleanValue playButtonSound;
        public final ModConfigSpec.BooleanValue mouseTweaksScrollEnabled;

        Client(ModConfigSpec.Builder builder) {
            builder.comment("Client Settings").push("client");
            this.sortButtonsPosition = builder.comment("Positions where sort buttons can display to help with conflicts with controls from other mods").defineEnum("sortButtonsPosition", (Enum)SortButtonsPosition.TITLE_LINE_RIGHT);
            this.playButtonSound = builder.comment("Whether click sound should play when custom buttons are clicked in gui").define("playButtonSound", true);
            this.mouseTweaksScrollEnabled = builder.comment("Whether scrolling in inventory should be handled by Mouse Tweaks mod if it is in the pack").define("mouseTweaksScrollEnabled", true);
            builder.pop();
        }
    }

    public static class Common {
        private boolean configChanged = false;
        public final EnabledItems enabledItems;

        public void initListeners(IEventBus modBus) {
            modBus.addListener(this::onConfigReload);
        }

        public void onConfigReload(ModConfigEvent.Reloading event) {
            this.enabledItems.enabledMap.clear();
        }

        Common(ModConfigSpec.Builder builder) {
            builder.comment("Common Settings").push("common");
            this.enabledItems = new EnabledItems(builder, () -> {
                this.configChanged = true;
            });
        }

        public void saveIfChanged() {
            if (this.configChanged) {
                this.configChanged = false;
                COMMON_SPEC.save();
            }
        }

        public static class EnabledItems {
            private final ModConfigSpec.ConfigValue<List<String>> itemsEnableList;
            private final Runnable onConfigChange;
            private final Map<ResourceLocation, Boolean> enabledMap = new ConcurrentHashMap<ResourceLocation, Boolean>();

            EnabledItems(ModConfigSpec.Builder builder, Runnable onConfigChange) {
                this.itemsEnableList = builder.comment("Disable / enable any items here (disables their recipes)").define("enabledItems", new ArrayList());
                this.onConfigChange = onConfigChange;
            }

            public boolean isItemEnabled(Item item) {
                return RegistryHelper.getRegistryName(BuiltInRegistries.ITEM, item).map(this::isItemEnabled).orElse(false);
            }

            public boolean isItemEnabled(ResourceLocation itemRegistryName) {
                if (!COMMON_SPEC.isLoaded()) {
                    return true;
                }
                if (this.enabledMap.isEmpty()) {
                    this.loadEnabledMap();
                }
                return this.enabledMap.computeIfAbsent(itemRegistryName, irn -> {
                    this.addEnabledItemToConfig(itemRegistryName);
                    return true;
                });
            }

            private void addEnabledItemToConfig(ResourceLocation itemRegistryName) {
                List list = (List)this.itemsEnableList.get();
                list.add(String.valueOf(itemRegistryName) + "|true");
                this.itemsEnableList.set((Object)list);
                this.onConfigChange.run();
            }

            private void loadEnabledMap() {
                for (String itemEnabled : (List)this.itemsEnableList.get()) {
                    String[] data = itemEnabled.split("\\|");
                    if (data.length == 2) {
                        this.enabledMap.put(ResourceLocation.parse((String)data[0]), Boolean.valueOf(data[1]));
                        continue;
                    }
                    SophisticatedCore.LOGGER.error("Wrong data for enabledItems - expected registry name|true/false when {} was provided", (Object)itemEnabled);
                }
            }
        }
    }
}

