/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum;

import dev.toma.configuration.Configuration;
import dev.toma.configuration.config.format.ConfigFormats;
import dev.toma.configuration.config.format.IConfigFormatHandler;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.tnt.collectorsalbum.common.Album;
import team.tnt.collectorsalbum.common.AlbumLocatorResult;
import team.tnt.collectorsalbum.common.PlayerAlbumTracker;
import team.tnt.collectorsalbum.common.init.ItemDataComponentRegistry;
import team.tnt.collectorsalbum.common.item.PackContents;
import team.tnt.collectorsalbum.common.resource.AlbumCardManager;
import team.tnt.collectorsalbum.common.resource.CardPackDropManager;
import team.tnt.collectorsalbum.common.resource.drops.ItemDropProvider;
import team.tnt.collectorsalbum.common.resource.util.ActionContext;
import team.tnt.collectorsalbum.common.resource.util.ListBasedOutputBuilder;
import team.tnt.collectorsalbum.config.CollectorsAlbumConfig;
import team.tnt.collectorsalbum.integrations.PlatformIntegrations;
import team.tnt.collectorsalbum.network.NetworkManager;
import team.tnt.collectorsalbum.network.S2C_OpenCardPackScreen;
import team.tnt.collectorsalbum.network.S2C_SendDatapackResources;
import team.tnt.collectorsalbum.platform.network.PlatformNetworkManager;

public class CollectorsAlbum {
    public static final String MOD_ID = "collectorsalbum";
    public static final Logger LOGGER = LogManager.getLogger((String)"CollectorsAlbum");
    public static final PlatformNetworkManager NETWORK_MANAGER = PlatformNetworkManager.create("collectorsalbum");
    private static CollectorsAlbumConfig config;
    public static final Component WARN_NO_DROPS;
    public static final Component USAGE;
    public static final Component LABEL_UNSET;

    public static void init() {
        config = (CollectorsAlbumConfig)Configuration.registerConfig(CollectorsAlbumConfig.class, (IConfigFormatHandler)ConfigFormats.YAML).getConfigInstance();
        CollectorsAlbum.registerPackets();
        PlatformIntegrations.registerAlbumFinders();
    }

    public static CollectorsAlbumConfig getConfig() {
        return config;
    }

    public static void tickPlayer(Player player) {
        Level level = player.level();
        long time = level.getGameTime();
        if (level.isClientSide() || time % 100L != 0L) {
            return;
        }
        CollectorsAlbum.actuallyTickPlayer(player);
    }

    public static void forceAlbumReload(Player player) {
        if (!player.level().isClientSide()) {
            CollectorsAlbum.actuallyTickPlayer(player);
        }
    }

    private static void actuallyTickPlayer(Player player) {
        PlayerAlbumTracker tracker = PlayerAlbumTracker.get();
        Album album = tracker.getAlbum(player).orElse(null);
        if (album == null) {
            AlbumLocatorResult result = tracker.findAlbum(player, null);
            if (!result.exists()) {
                return;
            }
            album = result.getAlbum();
            tracker.cacheAlbum(player, album);
        } else {
            AlbumLocatorResult result = tracker.findAlbum(player, album);
            if (!result.exists() || !result.getAlbum().test(album)) {
                tracker.deleteCachedAlbum(player.getUUID());
                album.removed(player);
                if (result.getAlbum() != null) {
                    tracker.cacheAlbum(player, result.getAlbum());
                    result.getAlbum().tick(player);
                }
                return;
            }
        }
        album.tick(player);
    }

    public static void sendPlayerDatapacks(ServerPlayer player) {
        if (player != null) {
            LOGGER.debug("Sending server resources to client {}", (Object)player.getUUID());
            PlatformNetworkManager.NETWORK.sendClientMessage(player, new S2C_SendDatapackResources());
            CollectorsAlbum.forceAlbumReload((Player)player);
        }
    }

    public static void playerLoggedOut(Player player) {
        PlayerAlbumTracker tracker = PlayerAlbumTracker.get();
        tracker.deleteCachedAlbum(player.getUUID());
    }

    public static void serverStopped() {
        PlayerAlbumTracker tracker = PlayerAlbumTracker.get();
        tracker.clearCache();
    }

    public static void openPack(ServerPlayer player) {
        ItemStack itemStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (!itemStack.has((DataComponentType)ItemDataComponentRegistry.PACK_DROPS_TABLE.get())) {
            LOGGER.warn("No pack drops path set for item {} on player {}", (Object)itemStack, (Object)player);
            return;
        }
        ListBasedOutputBuilder<ItemStack> outputBuilder = ListBasedOutputBuilder.createArrayListBased();
        CardPackDropManager dropManager = CardPackDropManager.getInstance();
        ResourceLocation lootTablePath = (ResourceLocation)itemStack.get((DataComponentType)ItemDataComponentRegistry.PACK_DROPS_TABLE.get());
        ItemDropProvider provider = dropManager.getProvider(lootTablePath);
        ActionContext context = ActionContext.of("player", player, "itemstack", itemStack, "random", player.getRandom());
        provider.generateDrops(context, outputBuilder);
        AlbumCardManager cardManager = AlbumCardManager.getInstance();
        List<ItemStack> generatedDrops = outputBuilder.getItems();
        List<ItemStack> drops = cardManager.processDrops(generatedDrops);
        if (generatedDrops.size() != drops.size()) {
            LOGGER.warn("Some invalid drops have been generated for player {} on item {}, filtering invalid drops...", (Object)player, (Object)itemStack);
            LOGGER.debug("Generated drops: {}, Filtered drops: {}", generatedDrops, drops);
        }
        player.getCooldowns().addCooldown(itemStack.getItem(), 20);
        if (drops.isEmpty()) {
            player.displayClientMessage(WARN_NO_DROPS, true);
            return;
        }
        Collections.shuffle(drops);
        itemStack.set((DataComponentType)ItemDataComponentRegistry.PACK_CONTENTS.get(), (Object)new PackContents(drops));
        LOGGER.debug("Player {} is opening card pack {} with generated drops: {}", (Object)player, (Object)itemStack, itemStack.get((DataComponentType)ItemDataComponentRegistry.PACK_CONTENTS.get()));
        PlatformNetworkManager.NETWORK.sendClientMessage(player, new S2C_OpenCardPackScreen(drops));
    }

    public static void addCardPackTooltip(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(USAGE);
        if (flag.isAdvanced()) {
            ResourceLocation dropsPath = (ResourceLocation)itemStack.get((DataComponentType)ItemDataComponentRegistry.PACK_DROPS_TABLE.get());
            Component description = dropsPath != null ? Component.literal((String)dropsPath.toString()) : LABEL_UNSET;
            tooltip.add((Component)Component.translatable((String)"collectorsalbum.label.custom_drop_table", (Object[])new Object[]{description}));
        }
    }

    private static void registerPackets() {
        NetworkManager.init();
    }

    static {
        WARN_NO_DROPS = Component.translatable((String)"collectorsalbum.label.pack_empty").withStyle(ChatFormatting.GOLD);
        USAGE = Component.translatable((String)"collectorsalbum.label.use_open").withStyle(ChatFormatting.GRAY);
        LABEL_UNSET = Component.translatable((String)"collectorsalbum.label.not_set").withStyle(ChatFormatting.RED);
    }
}

