/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum;

import com.mojang.brigadier.CommandDispatcher;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import team.tnt.collectorsalbum.CollectorsAlbum;
import team.tnt.collectorsalbum.client.CollectorsAlbumClient;
import team.tnt.collectorsalbum.common.command.CollectorsAlbumCommand;
import team.tnt.collectorsalbum.common.init.AlbumBonusRegistry;
import team.tnt.collectorsalbum.common.init.BlockRegistry;
import team.tnt.collectorsalbum.common.init.CardTypeRegistry;
import team.tnt.collectorsalbum.common.init.CategoryRegistry;
import team.tnt.collectorsalbum.common.init.ItemDataComponentRegistry;
import team.tnt.collectorsalbum.common.init.ItemDropProviderRegistry;
import team.tnt.collectorsalbum.common.init.ItemGroupRegistry;
import team.tnt.collectorsalbum.common.init.ItemRegistry;
import team.tnt.collectorsalbum.common.init.MenuRegistry;
import team.tnt.collectorsalbum.common.init.NumberProviderRegistry;
import team.tnt.collectorsalbum.common.init.SoundRegistry;
import team.tnt.collectorsalbum.common.resource.AlbumBonusManager;
import team.tnt.collectorsalbum.common.resource.AlbumCardManager;
import team.tnt.collectorsalbum.common.resource.AlbumCategoryManager;
import team.tnt.collectorsalbum.common.resource.CardPackDropManager;
import team.tnt.collectorsalbum.common.resource.MobAdditionalDropManager;
import team.tnt.collectorsalbum.platform.network.NeoforgeNetwork;
import team.tnt.collectorsalbum.platform.registration.NeoforgeRegistration;
import team.tnt.collectorsalbum.platform.resource.MenuScreenRegistration;

@Mod(value="collectorsalbum")
public class CollectorsAlbumNeoforge {
    public CollectorsAlbumNeoforge(IEventBus eventBus) {
        CollectorsAlbum.init();
        eventBus.addListener(this::addRegistries);
        eventBus.addListener(this::clientSetup);
        NeoforgeRegistration.subscribeRegistryEvent(eventBus, BlockRegistry.REGISTRY);
        NeoforgeRegistration.subscribeRegistryEvent(eventBus, ItemRegistry.REGISTRY);
        NeoforgeRegistration.subscribeRegistryEvent(eventBus, ItemGroupRegistry.REGISTRY);
        NeoforgeRegistration.subscribeRegistryEvent(eventBus, CardTypeRegistry.REGISTRY);
        NeoforgeRegistration.subscribeRegistryEvent(eventBus, CategoryRegistry.REGISTRY);
        NeoforgeRegistration.subscribeRegistryEvent(eventBus, SoundRegistry.REGISTRY);
        NeoforgeRegistration.subscribeRegistryEvent(eventBus, NumberProviderRegistry.REGISTRY);
        NeoforgeRegistration.subscribeRegistryEvent(eventBus, ItemDropProviderRegistry.REGISTRY);
        NeoforgeRegistration.subscribeRegistryEvent(eventBus, ItemDataComponentRegistry.REGISTRY);
        NeoforgeRegistration.subscribeRegistryEvent(eventBus, AlbumBonusRegistry.REGISTRY);
        NeoforgeRegistration.subscribeRegistryEvent(eventBus, MenuRegistry.REGISTRY);
        NeoforgeNetwork.subscribeRegistryEvent(eventBus, CollectorsAlbum.NETWORK_MANAGER);
        IEventBus neoBus = NeoForge.EVENT_BUS;
        neoBus.addListener(this::addReloadListeners);
        neoBus.addListener(this::playerTick);
        neoBus.addListener(this::onDatapackSync);
        neoBus.addListener(this::playerLoggedOut);
        neoBus.addListener(this::serverStopping);
        neoBus.addListener(this::onItemStartUse);
        neoBus.addListener(this::setPackUseDuration);
        neoBus.addListener(this::generateDrops);
        neoBus.addListener(this::addCommands);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            CollectorsAlbumClient.construct();
            eventBus.addListener(this::registerScreens);
        }
    }

    private void clientSetup(FMLClientSetupEvent event) {
        CollectorsAlbumClient.init();
    }

    private void playerTick(PlayerTickEvent.Post event) {
        CollectorsAlbum.tickPlayer(event.getEntity());
    }

    private void onDatapackSync(OnDatapackSyncEvent event) {
        Stream affectedPlayers = event.getRelevantPlayers();
        affectedPlayers.forEach(CollectorsAlbum::sendPlayerDatapacks);
    }

    private void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        CollectorsAlbum.playerLoggedOut(event.getEntity());
    }

    private void serverStopping(ServerStoppingEvent event) {
        CollectorsAlbum.serverStopped();
    }

    private void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)AlbumCardManager.getInstance());
        event.addListener((PreparableReloadListener)AlbumCategoryManager.getInstance());
        event.addListener((PreparableReloadListener)AlbumBonusManager.getInstance());
        event.addListener((PreparableReloadListener)CardPackDropManager.getInstance());
        event.addListener((PreparableReloadListener)MobAdditionalDropManager.getInstance());
    }

    private void addRegistries(NewRegistryEvent event) {
        NeoforgeRegistration.bindNewRegistries(event);
    }

    private void addCommands(RegisterCommandsEvent event) {
        CollectorsAlbumCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerScreens(RegisterMenuScreensEvent event) {
        MenuScreenRegistration.bindRefs((arg_0, arg_1) -> ((RegisterMenuScreensEvent)event).register(arg_0, arg_1));
    }

    private void onItemStartUse(PlayerInteractEvent.RightClickItem event) {
        InteractionHand hand;
        if (event.isCanceled()) {
            return;
        }
        Player player = event.getEntity();
        ItemStack itemStack = player.getItemInHand(hand = event.getHand());
        if (itemStack.has(ItemDataComponentRegistry.PACK_DROPS_TABLE)) {
            player.startUsingItem(hand);
            player.playSound((SoundEvent)SoundRegistry.PACK_OPEN.get(), 1.0f, 1.0f);
            event.setCancellationResult(InteractionResult.CONSUME);
        }
    }

    private void setPackUseDuration(LivingEntityUseItemEvent.Start event) {
        if (event.isCanceled()) {
            return;
        }
        ItemStack itemStack = event.getItem();
        if (itemStack.has(ItemDataComponentRegistry.PACK_DROPS_TABLE)) {
            event.setDuration(20);
        }
    }

    private void generateDrops(LivingEntityUseItemEvent.Finish event) {
        LivingEntity entity = event.getEntity();
        ItemStack itemStack = entity.getItemInHand(InteractionHand.MAIN_HAND);
        if (itemStack.has(ItemDataComponentRegistry.PACK_DROPS_TABLE) && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            CollectorsAlbum.openPack(player);
        }
    }
}

