/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.time.Duration;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import team.tnt.collectorsalbum.CollectorsAlbum;
import team.tnt.collectorsalbum.client.screen.AlbumMainPageScreen;
import team.tnt.collectorsalbum.client.screen.AlbumNavigationHelper;
import team.tnt.collectorsalbum.client.screen.BookmarkWidget;
import team.tnt.collectorsalbum.common.Album;
import team.tnt.collectorsalbum.common.AlbumCategory;
import team.tnt.collectorsalbum.common.AlbumCategoryUiTemplate;
import team.tnt.collectorsalbum.common.card.AlbumCard;
import team.tnt.collectorsalbum.common.init.ItemDataComponentRegistry;
import team.tnt.collectorsalbum.common.menu.AlbumCategoryMenu;

public class AlbumCategoryScreen
extends AbstractContainerScreen<AlbumCategoryMenu> {
    private final AlbumCategory category;
    private final List<Slot> cardSlots;
    private final ItemStack itemStack;

    public AlbumCategoryScreen(AlbumCategoryMenu menu, Inventory inventory, Component title, AlbumCategory category) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.category = category;
        AlbumCategoryUiTemplate template = category.visualTemplate();
        this.imageWidth = template.backgroundTexture.textureWidth();
        this.imageHeight = template.backgroundTexture.textureHeight();
        this.cardSlots = menu.slots.stream().filter(slot -> !(slot.container instanceof Inventory)).toList();
        this.itemStack = AlbumNavigationHelper.getStoredAlbum();
    }

    public AlbumCategory getCategory() {
        return this.category;
    }

    protected void init() {
        super.init();
        AlbumNavigationHelper.restoreMousePositionFromSnapshot();
        Album album = (Album)this.itemStack.get((DataComponentType)ItemDataComponentRegistry.ALBUM.get());
        if (album == null) {
            CollectorsAlbum.LOGGER.error("Failed to open album category {} due to invalid album item: {}", (Object)this.category.identifier(), (Object)this.itemStack);
            AlbumNavigationHelper.navigateHomepage();
            return;
        }
        PageButton prevPage = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(this.leftPos + 22, this.topPos + 156, false, btn -> AlbumNavigationHelper.navigatePreviousCategory(), true));
        prevPage.setTooltip(Tooltip.create((Component)AlbumNavigationHelper.getPreviousCategoryTitle()));
        prevPage.setTooltipDelay(Duration.ofSeconds(1L));
        if (AlbumNavigationHelper.hasNextCategory()) {
            PageButton nextPage = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(this.leftPos + 210, this.topPos + 156, true, btn -> AlbumNavigationHelper.navigateNextCategory(), true));
            nextPage.setTooltip(Tooltip.create((Component)AlbumNavigationHelper.getNextCategoryTitle()));
            nextPage.setTooltipDelay(Duration.ofSeconds(1L));
        }
        AlbumCategoryUiTemplate template = this.category.visualTemplate();
        AlbumMainPageScreen.getBookmarks(this.width, this.height, this.imageWidth, this.imageHeight, template.bookImageHeight).forEach(x$0 -> {
            BookmarkWidget cfr_ignored_0 = (BookmarkWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }

    public void removed() {
        AlbumNavigationHelper.captureCurrentMousePositionSnapshot();
        super.removed();
    }

    protected void renderLabels(GuiGraphics graphics, int $$1, int $$2) {
        Component categoryLabel = this.category.getDisplayText();
        Style displayTextStyle = categoryLabel.getStyle().withItalic(Boolean.valueOf(true));
        MutableComponent displayLabel = categoryLabel.copy().withStyle(ChatFormatting.BOLD);
        int width = this.font.width((FormattedText)displayLabel);
        graphics.drawString(this.font, (Component)displayLabel, (this.imageWidth - width) / 2, -25, 0xFFFFFF, false);
        Album album = (Album)this.itemStack.get((DataComponentType)ItemDataComponentRegistry.ALBUM.get());
        if (album != null) {
            int points = album.getCardsForCategory(this.category.identifier()).stream().mapToInt(AlbumCard::getPoints).sum();
            MutableComponent pointLabel = AlbumMainPageScreen.getPointLabel(points).withStyle(displayTextStyle);
            graphics.drawString(this.font, (Component)pointLabel, (this.imageWidth - this.font.width((FormattedText)pointLabel)) / 2, -15, 0xFFFFFF, false);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float v, int i, int i1) {
        AlbumCategoryUiTemplate template = this.category.visualTemplate();
        AlbumCategoryScreen.blitTextureTemplate(guiGraphics, this.leftPos, this.topPos, template.backgroundTexture);
        int[] cardNumbers = this.category.getCardNumbers();
        if (template.renderSlots) {
            for (int slot = 0; slot < this.cardSlots.size(); ++slot) {
                Slot cardSlot = this.cardSlots.get(slot);
                AlbumCategoryScreen.blitTextureTemplate(guiGraphics, this.leftPos + cardSlot.x - 1, this.topPos + cardSlot.y - 1, template.slotTexture);
                if (!template.renderSlotCardNumbers || cardSlot.hasItem()) continue;
                MutableComponent num = Component.literal((String)(template.cardNumberPrefix + cardNumbers[slot]));
                PoseStack pose = guiGraphics.pose();
                guiGraphics.enableScissor(this.leftPos + cardSlot.x, this.topPos + cardSlot.y, this.leftPos + cardSlot.x + template.slotTexture.width() - 2, this.topPos + cardSlot.y + template.slotTexture.height() - 2);
                pose.pushPose();
                pose.translate((float)(this.leftPos + cardSlot.x + 1), (float)(this.topPos + cardSlot.y + 1), 0.0f);
                pose.scale(0.75f, 0.75f, 0.75f);
                guiGraphics.drawString(this.font, (Component)num, 0, 0, template.slotCardNumberTextColor, false);
                pose.popPose();
                guiGraphics.disableScissor();
            }
        }
    }

    public static void blitTextureTemplate(GuiGraphics graphics, int x, int y, AlbumCategoryUiTemplate.TextureTemplate template) {
        int texWidth = template.textureWidth();
        int texHeight = template.textureHeight();
        float u = (float)template.texU() / (float)texWidth;
        float v = (float)template.texV() / (float)texHeight;
        graphics.blit(template.resource(), x, y, 0, u, v, template.width(), template.height(), texWidth, texHeight);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        this.renderTooltip(graphics, mouseX, mouseY);
    }
}

