/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.client.screen;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import team.tnt.collectorsalbum.client.screen.AlbumBonusesScreen;
import team.tnt.collectorsalbum.client.screen.AlbumCategoryScreen;
import team.tnt.collectorsalbum.client.screen.AlbumNavigationHelper;
import team.tnt.collectorsalbum.client.screen.BookmarkWidget;
import team.tnt.collectorsalbum.client.screen.LabelRenderable;
import team.tnt.collectorsalbum.client.screen.LabelWidget;
import team.tnt.collectorsalbum.client.screen.TextureRenderable;
import team.tnt.collectorsalbum.common.Album;
import team.tnt.collectorsalbum.common.AlbumCategory;
import team.tnt.collectorsalbum.common.card.CardRarity;
import team.tnt.collectorsalbum.common.init.ItemDataComponentRegistry;
import team.tnt.collectorsalbum.common.init.ItemRegistry;
import team.tnt.collectorsalbum.common.item.AlbumItem;
import team.tnt.collectorsalbum.common.resource.AlbumBonusManager;
import team.tnt.collectorsalbum.common.resource.AlbumCategoryManager;

public class AlbumMainPageScreen
extends Screen {
    public static final Component TITLE = Component.translatable((String)"screen.collectorsalbum.album.main").withStyle(ChatFormatting.BOLD);
    public static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"collectorsalbum", (String)"textures/ui/album.png");
    public static final int TEXT_COLOR = 8084556;
    private static final Component LABEL_RARITIES = Component.translatable((String)"collectorsalbum.text.statistics.rarities_label").withStyle(ChatFormatting.UNDERLINE);
    private static final Component LABEL_CATEGORIES = Component.translatable((String)"collectorsalbum.text.statistics.categories_label").withStyle(ChatFormatting.UNDERLINE);
    private static final String LANG_KEY_COLLECTED = "collectorsalbum.text.statistics.collected";
    private static final String LANG_KEY_POINTS = "collectorsalbum.text.statistics.points";
    private final ItemStack itemStack;
    protected int textureWidth = 256;
    protected int textureHeight = 256;
    protected int left;
    protected int top;

    AlbumMainPageScreen(ItemStack itemStack) {
        super(TITLE);
        this.itemStack = itemStack;
    }

    public static List<BookmarkWidget> getBookmarks(int guiWidth, int guiHeight, int albumWidth, int albumHeight, int bookImageHeight) {
        int left = (guiWidth - albumWidth) / 2;
        int top = (guiHeight - albumHeight) / 2 + 10;
        int right = left + albumWidth;
        Duration tooltipDelay = Duration.ofSeconds(1L);
        ArrayList<BookmarkWidget> bookmarks = new ArrayList<BookmarkWidget>();
        BookmarkWidget home = new BookmarkWidget(left - 32, top, 32, 18, true, ((AlbumItem)((Object)ItemRegistry.ALBUM.get())).getDefaultInstance(), () -> Minecraft.getInstance().screen instanceof AlbumMainPageScreen);
        home.setTooltip(Tooltip.create((Component)TITLE));
        home.setTooltipDelay(tooltipDelay);
        home.setAction(AlbumNavigationHelper::navigateHomepage);
        bookmarks.add(home);
        AlbumBonusManager bonusManager = AlbumBonusManager.getInstance();
        if (bonusManager.hasBonuses()) {
            BookmarkWidget bonuses = new BookmarkWidget(left - 32, top + 20, 32, 18, true, Items.EMERALD.getDefaultInstance(), () -> Minecraft.getInstance().screen instanceof AlbumBonusesScreen);
            bonuses.setTooltip(Tooltip.create((Component)AlbumBonusesScreen.TITLE));
            bonuses.setTooltipDelay(tooltipDelay);
            bonuses.setAction(AlbumNavigationHelper::navigateBonusesPage);
            bookmarks.add(bonuses);
        }
        List<AlbumCategory> categories = AlbumNavigationHelper.listCategoriesForBookmarks(bookImageHeight - 20);
        int index = 0;
        for (AlbumCategory category : categories) {
            BookmarkWidget categoryBookmark = new BookmarkWidget(right, top + index++ * 20, 32, 18, false, category.visualTemplate().bookmarkIcon, () -> {
                AlbumCategoryScreen catScreen;
                Screen patt0$temp = Minecraft.getInstance().screen;
                return patt0$temp instanceof AlbumCategoryScreen && (catScreen = (AlbumCategoryScreen)patt0$temp).getCategory().identifier().equals((Object)category.identifier());
            });
            categoryBookmark.setTooltip(Tooltip.create((Component)category.getDisplayText()));
            categoryBookmark.setTooltipDelay(tooltipDelay);
            categoryBookmark.setAction(() -> AlbumNavigationHelper.navigateCategory(category));
            bookmarks.add(categoryBookmark);
        }
        return bookmarks;
    }

    public void removed() {
        AlbumNavigationHelper.captureCurrentMousePositionSnapshot();
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void init() {
        this.left = (this.width - this.textureWidth) / 2;
        this.top = (this.height - this.textureHeight) / 2;
        this.addDefaultWidgets();
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.renderTransparentBackground(graphics);
    }

    public static MutableComponent getPointLabel(int points) {
        return Component.translatable((String)LANG_KEY_POINTS, (Object[])new Object[]{points});
    }

    protected void addDefaultWidgets() {
        List<BookmarkWidget> bookmarks = AlbumMainPageScreen.getBookmarks(this.width, this.height, this.textureWidth, this.textureHeight, 180);
        for (BookmarkWidget bookmark : bookmarks) {
            this.addRenderableWidget((GuiEventListener)bookmark);
        }
        this.addRenderableOnly(new TextureRenderable(BACKGROUND, this.left, this.top, this.textureWidth, this.textureHeight));
        int titleWidth = this.font.width((FormattedText)TITLE);
        this.addRenderableOnly(new LabelRenderable(TITLE, this.left + (128 - titleWidth) / 2, this.top + 14, 8084556));
        Album album = (Album)this.itemStack.get((DataComponentType)ItemDataComponentRegistry.ALBUM.get());
        if (album == null) {
            return;
        }
        AlbumCategoryManager categoryManager = AlbumCategoryManager.getInstance();
        int collected = album.countCards();
        int available = categoryManager.getCollectibleCardCount();
        MutableComponent percent = Component.literal((String)String.format(Locale.ROOT, "(%.1f%%)", Float.valueOf((float)collected / (float)available * 100.0f)));
        MutableComponent collectedCards = Component.translatable((String)LANG_KEY_COLLECTED, (Object[])new Object[]{collected, available});
        this.addRenderableOnly(new LabelRenderable((Component)collectedCards, this.left + 17, this.top + 30, 8084556));
        this.addRenderableOnly(new LabelRenderable((Component)percent, this.left + 17 + this.font.width((FormattedText)collectedCards) - this.font.width((FormattedText)percent), this.top + 40, 8084556));
        Map<CardRarity, Album.CardRarityStatistics> ratios = album.calculateRarityRatios();
        this.addRenderableOnly(new LabelRenderable(LABEL_RARITIES, this.left + 17, this.top + 55, 8084556));
        int rarityIndex = 0;
        for (CardRarity rarity : CardRarity.values()) {
            Album.CardRarityStatistics statistics = ratios.get((Object)rarity);
            MutableComponent rarityText = Component.literal((String)rarity.getDisplayText().getString());
            rarityText.getStyle().applyFormats(new ChatFormatting[]{ChatFormatting.RESET});
            String ratio = String.format(Locale.ROOT, "%.1f%%", Float.valueOf(statistics.getRatio() * 100.0f));
            MutableComponent label = Component.literal((String)(rarityText.getString() + ": " + ratio));
            LabelWidget labelWidget = (LabelWidget)this.addRenderableWidget((GuiEventListener)new LabelWidget(this.left + 20, this.top + 65 + rarityIndex++ * 10, this.font.width((FormattedText)label), 10, (Component)label, this.font, 8084556));
            labelWidget.setTooltip(Tooltip.create((Component)Component.literal((String)(statistics.collected() + "/" + statistics.total())).withStyle(ChatFormatting.GREEN)));
        }
        MutableComponent points = Component.literal((String)String.valueOf(album.getPoints())).withColor(-1069568).withStyle(ChatFormatting.BOLD);
        MutableComponent pointsLabel = Component.translatable((String)LANG_KEY_POINTS, (Object[])new Object[]{points}).withColor(8084556);
        this.addRenderableOnly(new LabelRenderable((Component)pointsLabel, this.left + 145, this.top + 14, false, 0xFFFFFF));
        this.addRenderableOnly(new LabelRenderable(LABEL_CATEGORIES, this.left + 145, this.top + 30, false, 8084556));
        List<Album.AlbumCategoryStatistics> statistics = album.calculateStatistics();
        for (int i = 0; i < Math.min(12, statistics.size()); ++i) {
            Album.AlbumCategoryStatistics stat = statistics.get(i);
            MutableComponent categoryLabelNoStyle = Component.literal((String)stat.category().getDisplayText().getString());
            categoryLabelNoStyle.getStyle().applyFormats(new ChatFormatting[]{ChatFormatting.RESET});
            MutableComponent displayLabel = Component.literal((String)(categoryLabelNoStyle.getString() + ": " + stat.collectedCards() + "/" + stat.allCards()));
            LabelWidget labelWidget = (LabelWidget)this.addRenderableWidget((GuiEventListener)new LabelWidget(this.left + 148, this.top + 40 + i * 10, 95, 10, (Component)displayLabel, this.font, 8084556));
            labelWidget.setTooltip(Tooltip.create((Component)Component.literal((String)String.format(Locale.ROOT, "%.1f%%", Float.valueOf(stat.getCollectedProgress() * 100.0f))).withStyle(ChatFormatting.GREEN)));
        }
        AlbumCategoryManager manager = AlbumCategoryManager.getInstance();
        AlbumCategory category = manager.getCategoryForPage(0);
        if (category != null) {
            PageButton button = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(this.left + 210, this.top + 156, true, btn -> AlbumNavigationHelper.navigateNextCategory(), true));
            button.setTooltip(Tooltip.create((Component)AlbumNavigationHelper.getNextCategoryTitle()));
            button.setTooltipDelay(Duration.ofSeconds(1L));
        }
    }
}

