/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.client.screen;

import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.lwjgl.glfw.GLFW;
import team.tnt.collectorsalbum.client.screen.AlbumBonusesScreen;
import team.tnt.collectorsalbum.client.screen.AlbumMainPageScreen;
import team.tnt.collectorsalbum.common.AlbumCategory;
import team.tnt.collectorsalbum.common.resource.AlbumCategoryManager;
import team.tnt.collectorsalbum.mixin.MouseHandlerAccessor;
import team.tnt.collectorsalbum.network.C2S_RequestAlbumCategoryInventory;
import team.tnt.collectorsalbum.platform.network.PlatformNetworkManager;

public final class AlbumNavigationHelper {
    private static ItemStack lastItemStack = ItemStack.EMPTY;
    private static int currentCategoryPage = -1;
    private static Double savedMouseX;
    private static Double savedMouseY;

    public static void captureCurrentMousePositionSnapshot() {
        MouseHandlerAccessor accessor = (MouseHandlerAccessor)Minecraft.getInstance().mouseHandler;
        savedMouseX = accessor.getXpos();
        savedMouseY = accessor.getYpos();
    }

    public static void restoreMousePositionFromSnapshot() {
        Minecraft minecraft = Minecraft.getInstance();
        MouseHandlerAccessor accessor = (MouseHandlerAccessor)minecraft.mouseHandler;
        if (savedMouseX != null && savedMouseY != null) {
            long windowPtr = minecraft.getWindow().getWindow();
            accessor.setXpos(savedMouseX);
            accessor.setYpos(savedMouseY);
            GLFW.glfwSetCursorPos((long)windowPtr, (double)savedMouseX, (double)savedMouseY);
            GLFW.glfwSetInputMode((long)windowPtr, (int)208897, (int)212993);
            savedMouseX = null;
            savedMouseY = null;
        }
    }

    public static void storeItemStack(ItemStack itemStack) {
        lastItemStack = itemStack;
    }

    public static void navigateHomepage() {
        AlbumNavigationHelper.resetCategoryPage();
        Minecraft.getInstance().setScreen((Screen)new AlbumMainPageScreen(lastItemStack));
    }

    public static void navigateBonusesPage() {
        AlbumNavigationHelper.resetCategoryPage();
        Minecraft.getInstance().setScreen((Screen)new AlbumBonusesScreen(lastItemStack));
    }

    public static ItemStack getStoredAlbum() {
        return lastItemStack;
    }

    public static void navigateNextCategory() {
        AlbumCategory category = AlbumNavigationHelper.peekCategory(currentCategoryPage + 1);
        if (category != null) {
            PlatformNetworkManager.NETWORK.sendServerMessage(new C2S_RequestAlbumCategoryInventory(category.identifier()));
            ++currentCategoryPage;
        } else {
            AlbumNavigationHelper.navigateHomepage();
        }
    }

    public static void navigatePreviousCategory() {
        AlbumCategory category = AlbumNavigationHelper.peekCategory(currentCategoryPage - 1);
        if (category != null) {
            PlatformNetworkManager.NETWORK.sendServerMessage(new C2S_RequestAlbumCategoryInventory(category.identifier()));
            --currentCategoryPage;
        } else {
            AlbumNavigationHelper.navigateHomepage();
        }
    }

    public static void navigateCategory(AlbumCategory category) {
        AlbumCategoryManager manager = AlbumCategoryManager.getInstance();
        currentCategoryPage = manager.getPageForCategory(category);
        PlatformNetworkManager.NETWORK.sendServerMessage(new C2S_RequestAlbumCategoryInventory(category.identifier()));
    }

    public static Component getNextCategoryTitle() {
        AlbumCategory category = AlbumNavigationHelper.peekCategory(currentCategoryPage + 1);
        return category != null ? category.getDisplayText() : AlbumMainPageScreen.TITLE;
    }

    public static Component getPreviousCategoryTitle() {
        AlbumCategory category = AlbumNavigationHelper.peekCategory(currentCategoryPage - 1);
        return category != null ? category.getDisplayText() : AlbumMainPageScreen.TITLE;
    }

    public static boolean hasNextCategory() {
        return AlbumNavigationHelper.getNextCategoryTitle() != AlbumMainPageScreen.TITLE;
    }

    private static AlbumCategory peekCategory(int page) {
        AlbumCategoryManager manager = AlbumCategoryManager.getInstance();
        return manager.getCategoryForPage(page);
    }

    public static List<AlbumCategory> listCategoriesForBookmarks(int height) {
        int size;
        AlbumCategoryManager manager = AlbumCategoryManager.getInstance();
        List<AlbumCategory> list = manager.listBookmarkableCategories();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        int bookmarkCount = height / 20;
        int halfCount = bookmarkCount / 2;
        int from = Math.max(0, currentCategoryPage - halfCount);
        int to = Math.min(list.size(), currentCategoryPage + halfCount + 1);
        if (to - from > bookmarkCount) {
            to = from + bookmarkCount;
        }
        if (to - from < bookmarkCount && to == list.size()) {
            from = Math.max(0, to - bookmarkCount);
        }
        if ((size = to - from) < Math.min(bookmarkCount, list.size())) {
            to = Math.min(list.size(), from + bookmarkCount);
        }
        return list.subList(from, to);
    }

    public static void resetCategoryPage() {
        currentCategoryPage = -1;
    }
}

