/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.client.screen;

import java.util.function.BooleanSupplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;

public class BookmarkWidget
extends AbstractWidget {
    private static final WidgetSprites LEFT_SIDE = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"collectorsalbum", (String)"textures/ui/bookmark_left.png"), ResourceLocation.fromNamespaceAndPath((String)"collectorsalbum", (String)"textures/ui/bookmark_disabled_left.png"), ResourceLocation.fromNamespaceAndPath((String)"collectorsalbum", (String)"textures/ui/bookmark_hovered_left.png"));
    private static final WidgetSprites RIGHT_SIDE = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"collectorsalbum", (String)"textures/ui/bookmark_right.png"), ResourceLocation.fromNamespaceAndPath((String)"collectorsalbum", (String)"textures/ui/bookmark_disabled_right.png"), ResourceLocation.fromNamespaceAndPath((String)"collectorsalbum", (String)"textures/ui/bookmark_hovered_right.png"));
    private final boolean leftside;
    private final ItemStack icon;
    private final BooleanSupplier isActive;
    private Runnable action;

    public BookmarkWidget(int x, int y, int width, int height, boolean leftside, ItemStack icon, BooleanSupplier isActive) {
        super(x, y, width, height, CommonComponents.EMPTY);
        this.leftside = leftside;
        this.icon = icon;
        this.isActive = isActive;
    }

    public void setAction(Runnable action) {
        this.action = action;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int i, int i1, float v) {
        WidgetSprites sprites = this.leftside ? LEFT_SIDE : RIGHT_SIDE;
        boolean hovered = this.isHovered();
        boolean active = this.isActive.getAsBoolean();
        ResourceLocation background = sprites.get(!active, hovered);
        guiGraphics.blit(background, this.getX(), this.getY(), 0, 0.0f, 0.0f, this.getWidth(), this.getHeight(), 32, 18);
        int hoverIconOffset = hovered || active ? -6 : 0;
        int baseIconOffset = this.leftside ? 15 : 0;
        guiGraphics.renderItem(this.icon, this.getX() + baseIconOffset + (this.leftside ? hoverIconOffset : -hoverIconOffset), this.getY() + 1);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public void playDownSound(SoundManager $$0) {
        $$0.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
    }

    public void onClick(double $$0, double $$1) {
        if (this.action != null) {
            this.action.run();
        }
    }
}

