/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import org.joml.Vector2d;
import team.tnt.collectorsalbum.common.card.AlbumCard;
import team.tnt.collectorsalbum.common.card.CardRarity;
import team.tnt.collectorsalbum.common.card.CardUiTemplate;
import team.tnt.collectorsalbum.common.card.RarityHolder;
import team.tnt.collectorsalbum.common.init.SoundRegistry;
import team.tnt.collectorsalbum.common.resource.AlbumCardManager;
import team.tnt.collectorsalbum.network.C2S_CompleteOpeningCardPack;
import team.tnt.collectorsalbum.platform.network.PlatformNetworkManager;

public class CardPackOpeningScreen
extends Screen {
    private static final Component TITLE = Component.translatable((String)"screen.collectorsalbum.card_pack_opening_screen");
    private static final ResourceLocation CARD_BG = ResourceLocation.fromNamespaceAndPath((String)"collectorsalbum", (String)"textures/ui/card_back.png");
    private static final int CARD_SIZE = 32;
    private static final int CARD_MARGIN = 8;
    private final FxEmitter emitter;
    private final List<ItemStack> drops;
    private final List<CardWidget> cardWidgets = new ArrayList<CardWidget>();

    public CardPackOpeningScreen(List<ItemStack> drops) {
        super(TITLE);
        this.emitter = new FxEmitter();
        this.drops = drops;
    }

    protected void init() {
        super.init();
        this.cardWidgets.clear();
        int rows = Mth.ceil((float)((float)this.drops.size() / 6.0f));
        int containerHeight = rows * 40 - 8;
        int containerTop = (this.height - containerHeight) / 2;
        for (int y = 0; y < rows; ++y) {
            int rowCols = Math.min(6, this.drops.size() - y * 6);
            int rowWidth = rowCols * 40 - 8;
            int rowLeft = (this.width - rowWidth) / 2;
            int rowTop = containerTop + y * 40;
            for (int x = 0; x < rowCols; ++x) {
                int index = x + y * 6;
                ItemStack drop = this.drops.get(index);
                CardWidget widget = this.addCardWidget(rowLeft + x * 40, rowTop, drop);
                widget.setOnIconFlipped(this::onCardFlipped);
                widget.setPositionAnimationDelay(index * 3);
            }
        }
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.renderTransparentBackground(graphics);
        this.emitter.draw(graphics, delta);
    }

    public void removed() {
        PlatformNetworkManager.NETWORK.sendServerMessage(new C2S_CompleteOpeningCardPack());
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void tick() {
        this.emitter.update();
        this.cardWidgets.forEach(CardWidget::tick);
    }

    private void onCardFlipped(CardWidget widget) {
        AlbumCard card = widget.card;
        CardUiTemplate template = card.template();
        Integer[] effects = template.effectColors();
        Integer[] durations = template.effectDurations();
        double speed = 4.0;
        int count = Math.min(20 + card.getPoints() * 5, 100) / Math.max(effects.length, 1);
        for (int i = 0; i < effects.length; ++i) {
            float centerX = (float)widget.getX() + (float)widget.getWidth() / 2.0f;
            float centerY = (float)widget.getY() + (float)widget.getHeight() / 2.0f;
            this.emitter.emit(centerX, centerY, effects[i], durations[i], count, speed);
        }
    }

    private CardWidget addCardWidget(int x, int y, ItemStack itemStack) {
        int left = (this.width - 32) / 2;
        int top = this.height - 16;
        CardWidget widget = new CardWidget(left, top, 32, 32, x, y, itemStack);
        this.cardWidgets.add(widget);
        return (CardWidget)this.addRenderableWidget((GuiEventListener)widget);
    }

    static void renderFullTexture(ResourceLocation path, Matrix4f pose, float x, float y, float z, float width, float height) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)path);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        builder.addVertex(pose, x, y, z).setUv(0.0f, 0.0f);
        builder.addVertex(pose, x, y + height, z).setUv(0.0f, 1.0f);
        builder.addVertex(pose, x + width, y + height, z).setUv(1.0f, 1.0f);
        builder.addVertex(pose, x + width, y, z).setUv(1.0f, 0.0f);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
    }

    static void renderFullColoredTexture(ResourceLocation path, Matrix4f pose, float x, float y, float z, float width, float height, int color) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)path);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        builder.addVertex(pose, x, y, z).setUv(0.0f, 0.0f).setColor(color);
        builder.addVertex(pose, x, y + height, z).setUv(0.0f, 1.0f).setColor(color);
        builder.addVertex(pose, x + width, y + height, z).setUv(1.0f, 1.0f).setColor(color);
        builder.addVertex(pose, x + width, y, z).setUv(1.0f, 0.0f).setColor(color);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
    }

    private static class FxEmitter {
        private final List<FxElement> liveElements = new ArrayList<FxElement>();

        private FxEmitter() {
        }

        void emit(float x, float y, int color, int lifetime, int count, double dirMul) {
            for (int i = 0; i < count; ++i) {
                FxElement element = new FxElement(x, y, color, lifetime);
                double xRand = Math.random() - Math.random();
                double yRand = Math.random() - Math.random();
                element.setDir(new Vector2d(xRand * dirMul, yRand * dirMul));
                this.liveElements.add(element);
            }
        }

        void update() {
            Iterator<FxElement> it = this.liveElements.iterator();
            while (it.hasNext()) {
                FxElement element = it.next();
                element.update();
                if (!element.shouldRemove()) continue;
                it.remove();
            }
        }

        void draw(GuiGraphics graphics, float delta) {
            this.liveElements.forEach(fx -> fx.draw(graphics, delta));
        }
    }

    private static final class CardWidget
    extends AbstractWidget {
        private static final int TOTAL_MOVE_TIME = 10;
        private static final int TOTAL_FLIP_TIME = 20;
        private final int originalX;
        private final int originalY;
        private final int targetX;
        private final int targetY;
        private final AlbumCard card;
        private final ResourceLocation itemTexture;
        private Consumer<CardWidget> onIconFlipped;
        private Consumer<CardWidget> onFlipFinish;
        private boolean flipped;
        private boolean flipping;
        private int flipCurrent;
        private int flipOld;
        private int positionCurrent;
        private int positionOld;
        private int positionAnimationDelay;

        public CardWidget(int x, int y, int width, int height, int targetX, int targetY, ItemStack itemStack) {
            super(x, y, width, height, CommonComponents.EMPTY);
            this.originalX = x;
            this.originalY = y;
            this.targetX = targetX;
            this.targetY = targetY;
            this.card = AlbumCardManager.getInstance().getCardInfo(itemStack.getItem()).orElse(null);
            this.itemTexture = CardWidget.getCardTexture(this.card, itemStack);
        }

        public void setOnIconFlipped(Consumer<CardWidget> onIconFlipped) {
            this.onIconFlipped = onIconFlipped;
        }

        public void setOnFlipFinish(Consumer<CardWidget> onFlipFinish) {
            this.onFlipFinish = onFlipFinish;
        }

        public void setPositionAnimationDelay(int positionAnimationDelay) {
            this.positionAnimationDelay = positionAnimationDelay;
        }

        public void tick() {
            this.tickPosition();
            this.tickFlipping();
        }

        public void playDownSound(SoundManager manager) {
            SoundEvent event;
            AlbumCard albumCard = this.card;
            if (albumCard instanceof RarityHolder) {
                RarityHolder holder = (RarityHolder)albumCard;
                CardRarity rarity = holder.rarity();
                event = rarity.getFlipSoundRef().get();
            } else {
                event = (SoundEvent)SoundRegistry.FLIP_COMMON.get();
            }
            manager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)event, (float)1.0f));
        }

        public void onClick(double $$0, double $$1) {
            if (this.flipping || this.flipped) {
                return;
            }
            this.flipping = true;
        }

        protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float deltaTicks) {
            this.updatePosition(deltaTicks);
            this.renderCardWithFlipAnimation(graphics, deltaTicks);
        }

        private void updatePosition(float delta) {
            if (this.positionOld == this.positionCurrent && this.positionCurrent > 0) {
                this.setX(this.targetX);
                this.setY(this.targetY);
                return;
            }
            float positionAnimProgress = Mth.lerp((float)delta, (float)this.positionOld, (float)this.positionCurrent) / 10.0f;
            float positionAnimEased = 1.0f - (float)Math.pow(1.0f - positionAnimProgress, 3.0);
            int xDelta = this.targetX - this.originalX;
            int yDelta = this.targetY - this.originalY;
            this.setX((int)((float)this.originalX + (float)xDelta * positionAnimEased));
            this.setY((int)((float)this.originalY + (float)yDelta * positionAnimEased));
        }

        private void renderCardWithFlipAnimation(GuiGraphics graphics, float delta) {
            float px = this.getX();
            int py = this.getY();
            float pWidth = this.getWidth();
            int pHeight = this.getHeight();
            if (this.flipping) {
                float flipProgress;
                boolean wasFlipped = this.flipped;
                float flipOld = (float)this.flipOld / 20.0f;
                float flipActual = (float)this.flipCurrent / 20.0f;
                float flipProgressRaw = Mth.lerp((float)delta, (float)flipOld, (float)flipActual);
                float f = flipProgress = (double)flipProgressRaw < 0.5 ? 4.0f * flipProgressRaw * flipProgressRaw * flipProgressRaw : 1.0f - (float)Math.pow(-2.0f * flipProgressRaw + 2.0f, 3.0) / 2.0f;
                if ((double)flipProgress >= 0.5) {
                    this.flipped = true;
                }
                float amount = this.flipped ? (flipProgress - 0.5f) / 0.5f : 1.0f - flipProgress / 0.5f;
                float halfWidth = (float)this.getWidth() / 2.0f;
                px = (float)this.getX() + halfWidth * (1.0f - amount);
                pWidth = (float)this.getWidth() * amount;
                if (this.flipped && !wasFlipped && this.onIconFlipped != null && this.card != null) {
                    this.onIconFlipped.accept(this);
                }
            }
            ResourceLocation texture = this.flipped ? this.itemTexture : CARD_BG;
            Matrix4f poseMat = graphics.pose().last().pose();
            CardPackOpeningScreen.renderFullTexture(texture, poseMat, px, py, 400.0f, pWidth, pHeight);
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }

        protected boolean clicked(double mouseX, double mouseY) {
            return !this.flipped && !this.flipping && super.clicked(mouseX, mouseY);
        }

        private void tickPosition() {
            if (this.positionAnimationDelay > 0) {
                --this.positionAnimationDelay;
                return;
            }
            this.positionOld = this.positionCurrent;
            if (this.positionCurrent < 10 && this.positionCurrent++ == 0) {
                SoundManager manager = Minecraft.getInstance().getSoundManager();
                manager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundRegistry.FLIP_COMMON.get()), (float)1.5f, (float)0.25f));
            }
        }

        private void tickFlipping() {
            if (!this.flipping) {
                return;
            }
            this.flipOld = this.flipCurrent;
            if (this.flipCurrent >= 20) {
                this.flipping = false;
                if (this.onFlipFinish != null && this.card != null) {
                    this.onFlipFinish.accept(this);
                }
                return;
            }
            ++this.flipCurrent;
        }

        private static ResourceLocation getCardTexture(AlbumCard card, ItemStack itemStack) {
            if (card == null) {
                return CardWidget.getDefaultItemTexture(itemStack);
            }
            CardUiTemplate template = card.template();
            return template.cardTexture() != null ? template.cardTexture() : CardWidget.getDefaultItemTexture(itemStack);
        }

        private static ResourceLocation getDefaultItemTexture(ItemStack itemStack) {
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem());
            return ResourceLocation.fromNamespaceAndPath((String)itemId.getNamespace(), (String)("textures/item/" + itemId.getPath() + ".png"));
        }
    }

    private static class FxElement {
        private static final ResourceLocation[] PATHS = new ResourceLocation[]{FxElement.spark(0), FxElement.spark(1), FxElement.spark(2), FxElement.spark(3), FxElement.spark(4), FxElement.spark(5), FxElement.spark(6), FxElement.spark(7)};
        private float x;
        private float y;
        private float xOld;
        private float yOld;
        private final int color;
        private final int stageLife;
        private int stage;
        private int stageLifeLeft;
        private Vector2d direction;

        public FxElement(float x, float y, int color, int stageLife) {
            this.x = x;
            this.y = y;
            this.xOld = x;
            this.yOld = y;
            this.color = color;
            this.stageLife = stageLife;
            this.stageLifeLeft = stageLife;
            this.stage = PATHS.length - 1;
        }

        void draw(GuiGraphics graphics, float delta) {
            ResourceLocation path = PATHS[this.stage];
            Matrix4f pose = graphics.pose().last().pose();
            float scale = 8.0f;
            float halfScale = scale / 2.0f;
            float xPos = Mth.lerp((float)delta, (float)this.xOld, (float)this.x);
            float yPos = Mth.lerp((float)delta, (float)this.yOld, (float)this.y);
            CardPackOpeningScreen.renderFullColoredTexture(path, pose, xPos - halfScale, yPos - halfScale, 0.0f, scale, scale, 0xFF000000 | this.color);
        }

        void update() {
            this.xOld = this.x;
            this.yOld = this.y;
            if (--this.stageLifeLeft < 0) {
                --this.stage;
                this.stageLifeLeft = this.stageLife;
            }
            if (this.direction != null) {
                this.x += (float)this.direction.x;
                this.y += (float)this.direction.y;
                this.direction.mul((double)0.95f);
            }
        }

        void setDir(Vector2d dir) {
            this.direction = dir;
        }

        boolean shouldRemove() {
            return this.stage == 0 && this.stageLifeLeft <= 0;
        }

        private static ResourceLocation spark(int index) {
            return ResourceLocation.withDefaultNamespace((String)String.format("textures/particle/spark_%d.png", index));
        }
    }
}

