/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.client.screen;

import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;

public class LabelWidget
extends AbstractWidget {
    private final Font font;
    private final int textColor;
    private final boolean scrolling;

    public LabelWidget(int x, int y, int width, int height, Component label, Font font, int textColor, boolean scrolling) {
        super(x, y, width, height, label);
        this.font = font;
        this.textColor = textColor;
        this.scrolling = scrolling;
    }

    public LabelWidget(int x, int y, int width, int height, Component label, Font font, int textColor) {
        this(x, y, width, height, label, font, textColor, false);
    }

    protected boolean clicked(double mouseX, double mouseY) {
        return false;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.enableScissor(this.getX(), this.getY(), this.getRight(), this.getBottom());
        if (this.scrolling) {
            LabelWidget.renderScrollingStringInternal(guiGraphics, this.font, this.getMessage(), this.getX(), this.getX(), this.getY(), this.getRight(), this.getBottom(), this.textColor);
        } else {
            guiGraphics.drawString(this.font, this.getMessage(), this.getX(), this.getY(), this.textColor, false);
        }
        guiGraphics.disableScissor();
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    private static void renderScrollingStringInternal(GuiGraphics graphics, Font font, Component label, int textX, int x, int y, int width, int height, int color) {
        int textWidth = font.width((FormattedText)label);
        int containerHeight = y + height;
        Objects.requireNonNull(font);
        int posY = (containerHeight - 9) / 2 + 1;
        int containerWidth = width - x;
        if (textWidth > containerWidth) {
            int $$12 = textWidth - containerWidth;
            double $$13 = (double)Util.getMillis() / 1000.0;
            double $$14 = Math.max((double)$$12 * 0.5, 3.0);
            double $$15 = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * $$13 / $$14)) / 2.0 + 0.5;
            double $$16 = Mth.lerp((double)$$15, (double)0.0, (double)$$12);
            graphics.enableScissor(x, y, width, height);
            graphics.drawString(font, label, x - (int)$$16, posY, color, false);
            graphics.disableScissor();
        } else {
            graphics.drawString(font, label, textX, posY, color, false);
        }
    }
}

