/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import team.tnt.collectorsalbum.CollectorsAlbum;
import team.tnt.collectorsalbum.common.AlbumCategory;
import team.tnt.collectorsalbum.common.card.AlbumCard;
import team.tnt.collectorsalbum.common.card.CardRarity;
import team.tnt.collectorsalbum.common.card.RarityHolder;
import team.tnt.collectorsalbum.common.resource.AlbumBonusManager;
import team.tnt.collectorsalbum.common.resource.AlbumCardManager;
import team.tnt.collectorsalbum.common.resource.AlbumCategoryManager;
import team.tnt.collectorsalbum.common.resource.util.ActionContext;
import team.tnt.collectorsalbum.platform.Codecs;

public final class Album
implements Predicate<Album> {
    public static final Codec<ItemStack> NULLABLE_ITEMSTACK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.ITEM.holderByNameCodec().fieldOf("id").forGetter(ItemStack::getItemHolder), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(ItemStack::getCount), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(ItemStack::getComponentsPatch)).apply((Applicative)instance, ItemStack::new));
    public static final Codec<Album> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.CODEC.fieldOf("albumId").forGetter(t -> t.albumId), (App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, Codecs.setCodec(AlbumCardManager.BY_NAME_CODEC)).xmap(HashMap::new, map -> map).fieldOf("cardsByCategory").forGetter(t -> (HashMap)t.cardsByCategory), (App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, Codecs.nonNullListCodec(NULLABLE_ITEMSTACK_CODEC, ItemStack.EMPTY)).fieldOf("categoryInventories").forGetter(t -> t.categoryInventories)).apply((Applicative)instance, Album::new));
    private final UUID albumId;
    private final Map<ResourceLocation, Set<AlbumCard>> cardsByCategory;
    private final Map<ResourceLocation, NonNullList<ItemStack>> categoryInventories;
    private final int points;

    private Album(Mutable mutable) {
        this.albumId = UUID.randomUUID();
        this.cardsByCategory = new HashMap<ResourceLocation, Set<AlbumCard>>();
        this.categoryInventories = new HashMap<ResourceLocation, NonNullList<ItemStack>>();
        int pointCounter = 0;
        AlbumCardManager manager = AlbumCardManager.getInstance();
        for (Map.Entry<ResourceLocation, NonNullList<ItemStack>> entry : mutable.inventories.entrySet()) {
            ResourceLocation key = entry.getKey();
            NonNullList<ItemStack> inventory = entry.getValue();
            for (int i = 0; i < inventory.size(); ++i) {
                ItemStack itemStack = (ItemStack)inventory.get(i);
                if (itemStack.isEmpty()) continue;
                AlbumCard card = manager.getCardInfo(itemStack.getItem()).orElse(null);
                if (card != null) {
                    this.cardsByCategory.computeIfAbsent(key, t -> new HashSet()).add(card);
                    this.categoryInventories.computeIfAbsent(key, t -> NonNullList.withSize((int)inventory.size(), (Object)ItemStack.EMPTY)).set(i, (Object)itemStack.copy());
                    pointCounter += card.getPoints();
                    continue;
                }
                CollectorsAlbum.LOGGER.warn("Couldn't find album card for key {} in album {}, ignoring", (Object)key, (Object)this.albumId);
            }
        }
        this.points = pointCounter;
    }

    private Album(UUID albumId) {
        this(albumId, new HashMap<ResourceLocation, Set<AlbumCard>>(), new HashMap<ResourceLocation, NonNullList<ItemStack>>());
    }

    public Album(UUID albumId, Map<ResourceLocation, Set<AlbumCard>> cardsByCategory, Map<ResourceLocation, NonNullList<ItemStack>> categoryInventories) {
        this.albumId = albumId;
        this.cardsByCategory = cardsByCategory;
        this.categoryInventories = categoryInventories;
        this.points = cardsByCategory.values().stream().flatMap(Collection::stream).mapToInt(AlbumCard::getPoints).sum();
    }

    public static Album emptyAlbum() {
        return new Album(UUID.randomUUID());
    }

    @Override
    public boolean test(Album album) {
        return album != null && this.albumId.equals(album.albumId);
    }

    public int getPoints() {
        return this.points;
    }

    public NonNullList<ItemStack> getInventory(ResourceLocation category) {
        return this.categoryInventories.getOrDefault(category, (NonNullList<ItemStack>)NonNullList.withSize((int)1, (Object)ItemStack.EMPTY));
    }

    public Collection<AlbumCard> getCardsForCategory(ResourceLocation category) {
        Set<AlbumCard> cards = this.cardsByCategory.get(category);
        return cards == null ? Collections.emptyList() : cards;
    }

    public int countCards() {
        return this.cardsByCategory.values().stream().mapToInt(Set::size).sum();
    }

    public Map<CardRarity, CardRarityStatistics> calculateRarityRatios() {
        List<RarityHolder> rarityCards = this.cardsByCategory.values().stream().flatMap(Collection::stream).filter(card -> card instanceof RarityHolder).map(card -> (RarityHolder)card).toList();
        EnumMap<CardRarity, CardRarityStatistics> map = new EnumMap<CardRarity, CardRarityStatistics>(CardRarity.class);
        Map<CardRarity, List<RarityHolder>> byRarity = rarityCards.stream().collect(Collectors.groupingBy(RarityHolder::rarity));
        int totalCards = Math.max(rarityCards.size(), 1);
        for (CardRarity rarity : CardRarity.values()) {
            List list = byRarity.getOrDefault((Object)rarity, Collections.emptyList());
            CardRarityStatistics statistics = new CardRarityStatistics(list.size(), totalCards);
            map.put(rarity, statistics);
        }
        return map;
    }

    public List<AlbumCategoryStatistics> calculateStatistics() {
        AlbumCategoryManager manager = AlbumCategoryManager.getInstance();
        Collection<AlbumCategory> categories = manager.listCategories();
        return categories.stream().map(cat -> {
            Set cardsInCategory = this.cardsByCategory.getOrDefault(cat.identifier(), Collections.emptySet());
            int categoryTotal = cat.getCardNumbers().length;
            int categoryCollected = cardsInCategory.size();
            return new AlbumCategoryStatistics((AlbumCategory)cat, categoryCollected, categoryTotal);
        }).filter(stat -> stat.allCards() > 0).sorted(Comparator.comparingDouble(AlbumCategoryStatistics::getCollectedProgress).reversed()).toList();
    }

    public void tick(Player player) {
        ActionContext context = ActionContext.of("player", player, "album", this);
        AlbumBonusManager manager = AlbumBonusManager.getInstance();
        manager.applyBonuses(context);
    }

    public void removed(Player player) {
        ActionContext context = ActionContext.of("player", player, "album", this);
        AlbumBonusManager manager = AlbumBonusManager.getInstance();
        manager.removeBonuses(context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Album album = (Album)o;
        return Objects.equals(this.albumId, album.albumId);
    }

    public int hashCode() {
        return Objects.hashCode(this.albumId);
    }

    public static final class Mutable {
        private final Map<ResourceLocation, NonNullList<ItemStack>> inventories;

        public Mutable(Album album) {
            HashMap<ResourceLocation, NonNullList<ItemStack>> inventories = new HashMap<ResourceLocation, NonNullList<ItemStack>>();
            for (Map.Entry<ResourceLocation, NonNullList<ItemStack>> entry : album.categoryInventories.entrySet()) {
                ResourceLocation key = entry.getKey();
                NonNullList<ItemStack> categoryInventory = entry.getValue();
                AlbumCategoryManager.getInstance().findById(key).ifPresent(category -> {
                    NonNullList inventory = NonNullList.withSize((int)category.getCardNumbers().length, (Object)ItemStack.EMPTY);
                    for (int i = 0; i < categoryInventory.size(); ++i) {
                        ItemStack itemStack = (ItemStack)categoryInventory.get(i);
                        if (itemStack.isEmpty()) continue;
                        inventory.set(i, (Object)itemStack.copy());
                    }
                    inventories.put(key, inventory);
                });
            }
            this.inventories = inventories;
        }

        public void set(ResourceLocation category, int index, ItemStack itemStack) {
            NonNullList inventory = this.inventories.get(category);
            if (inventory == null) {
                AlbumCategoryManager manager = AlbumCategoryManager.getInstance();
                AlbumCategory albumCategory = manager.findById(category).orElseThrow(() -> new IllegalArgumentException(String.format("Attempting to insert item %s into unknown category %s", itemStack, category)));
                inventory = NonNullList.withSize((int)albumCategory.getCardNumbers().length, (Object)ItemStack.EMPTY);
                this.inventories.put(category, (NonNullList<ItemStack>)inventory);
            }
            inventory.set(index, (Object)itemStack.copy());
        }

        public Album toImmutable() {
            return new Album(this);
        }

        public String toString() {
            return "MutableAlbum{inventories=" + String.valueOf(this.inventories) + "}";
        }
    }

    public record CardRarityStatistics(int collected, int total) {
        public float getRatio() {
            return this.total > 0 ? (float)this.collected / (float)this.total : 0.0f;
        }
    }

    public record AlbumCategoryStatistics(AlbumCategory category, int collectedCards, int allCards) {
        public float getCollectedProgress() {
            return this.allCards > 0 ? (float)this.collectedCards / (float)this.allCards : 0.0f;
        }
    }
}

