/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import team.tnt.collectorsalbum.common.Album;
import team.tnt.collectorsalbum.common.AlbumLocatorResult;
import team.tnt.collectorsalbum.common.init.ItemDataComponentRegistry;
import team.tnt.collectorsalbum.common.init.RegistryTags;
import team.tnt.collectorsalbum.integrations.PlatformIntegrations;

public final class PlayerAlbumTracker {
    private static final PlayerAlbumTracker INSTANCE = new PlayerAlbumTracker();
    private final Map<UUID, Album> playerAlbums = new HashMap<UUID, Album>();

    private PlayerAlbumTracker() {
    }

    public static PlayerAlbumTracker get() {
        return INSTANCE;
    }

    public AlbumLocatorResult findAlbum(Player player, Album previousAlbum) {
        AlbumLocatorResult integrationResult = PlatformIntegrations.getAlbumLocatorResult(player, previousAlbum);
        if (integrationResult.exists()) {
            return integrationResult;
        }
        Inventory inventory = player.getInventory();
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack itemStack = inventory.getItem(i);
            if (itemStack.isEmpty() || !itemStack.is(RegistryTags.Items.ALBUM)) continue;
            Album album = (Album)itemStack.get((DataComponentType)ItemDataComponentRegistry.ALBUM.get());
            if (previousAlbum != null && previousAlbum.test(album)) {
                return AlbumLocatorResult.found(itemStack, previousAlbum, i);
            }
            return AlbumLocatorResult.found(itemStack, album, i);
        }
        return AlbumLocatorResult.notFound();
    }

    public Optional<Album> getAlbum(Player player) {
        return this.getAlbum(player.getUUID());
    }

    public Optional<Album> getAlbum(UUID playerUuid) {
        return Optional.ofNullable(this.playerAlbums.get(playerUuid));
    }

    public void cacheAlbum(Player player, Album album) {
        this.cacheAlbum(player.getUUID(), album);
    }

    public void cacheAlbum(UUID playerUuid, Album album) {
        this.playerAlbums.put(playerUuid, Objects.requireNonNull(album));
    }

    public void deleteCachedAlbum(UUID playerUuid) {
        this.playerAlbums.remove(playerUuid);
    }

    public void clearCache() {
        this.playerAlbums.clear();
    }
}

