/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.card;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import team.tnt.collectorsalbum.common.AlbumBonusDescriptionOutput;
import team.tnt.collectorsalbum.common.card.CardFilter;
import team.tnt.collectorsalbum.common.card.CardRarity;
import team.tnt.collectorsalbum.common.card.IntFilter;
import team.tnt.collectorsalbum.platform.Codecs;

public record CardCategoryFilter(Set<CardRarity> rarities, IntFilter numberFilter, IntFilter pointFilter, IntFilter cardCountFilter, IntFilter categoryPointFilter) implements CardFilter
{
    public static final Codec<CardCategoryFilter> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codecs.setCodec(Codecs.simpleEnumCodec(CardRarity.class, s -> s.toUpperCase(Locale.ROOT))).optionalFieldOf("rarities", Collections.emptySet()).forGetter(CardCategoryFilter::rarities), (App)IntFilter.CODEC.optionalFieldOf("numbers", (Object)IntFilter.NO_FILTER).forGetter(CardCategoryFilter::numberFilter), (App)IntFilter.CODEC.optionalFieldOf("points", (Object)IntFilter.NO_FILTER).forGetter(CardCategoryFilter::pointFilter), (App)IntFilter.CODEC.optionalFieldOf("cards", (Object)IntFilter.NO_FILTER).forGetter(CardCategoryFilter::cardCountFilter), (App)IntFilter.CODEC.optionalFieldOf("categoryPoints", (Object)IntFilter.NO_FILTER).forGetter(CardCategoryFilter::categoryPointFilter)).apply((Applicative)instance, CardCategoryFilter::new));
    public static final CardCategoryFilter NO_FILTER = new CardCategoryFilter(Collections.emptySet(), IntFilter.NO_FILTER, IntFilter.NO_FILTER, IntFilter.NO_FILTER, IntFilter.NO_FILTER);
    public static final Component LABEL_FILTER = Component.translatable((String)"collectorsalbum.label.filter");
    public static final Component LABEL_FILTER_RARITY = Component.translatable((String)"collectorsalbum.label.filter.rarities");
    public static final Component LABEL_FILTER_NUMBER = Component.translatable((String)"collectorsalbum.label.filter.numbers");
    public static final Component LABEL_FILTER_POINT = Component.translatable((String)"collectorsalbum.label.filter.points");
    public static final Component LABEL_FILTER_CARDS = Component.translatable((String)"collectorsalbum.label.filter.cards");
    public static final Component LABEL_FILTER_CATEGORY_POINTS = Component.translatable((String)"collectorsalbum.label.filter.category_points");

    public void generateDescriptionLabels(AlbumBonusDescriptionOutput descriptionOutput) {
        if (!this.rarities.isEmpty()) {
            MutableComponent raritiesTooltip = Component.literal((String)("[" + String.join((CharSequence)",", this.rarities().stream().map(rarity -> rarity.getDisplayText().getString()).toList()) + "]"));
            descriptionOutput.text(LABEL_FILTER_RARITY, (Component)raritiesTooltip);
        }
        if (this.numberFilter != IntFilter.NO_FILTER) {
            descriptionOutput.text(LABEL_FILTER_NUMBER, this.numberFilter.getDisplayComponent());
        }
        if (this.pointFilter != IntFilter.NO_FILTER) {
            descriptionOutput.text(LABEL_FILTER_POINT, this.pointFilter.getDisplayComponent());
        }
        if (this.cardCountFilter != IntFilter.NO_FILTER) {
            descriptionOutput.text(LABEL_FILTER_CARDS, this.cardCountFilter.getDisplayComponent());
        }
        if (this.categoryPointFilter != IntFilter.NO_FILTER) {
            descriptionOutput.text(LABEL_FILTER_CATEGORY_POINTS, this.categoryPointFilter.getDisplayComponent());
        }
    }
}

