/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.card;

import java.util.Locale;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import team.tnt.collectorsalbum.common.init.SoundRegistry;

public enum CardRarity {
    COMMON(new Integer[]{0xAAAAAA}, new Integer[]{5}, SoundRegistry.FLIP_COMMON, text -> text.withStyle(ChatFormatting.WHITE)),
    UNCOMMON(new Integer[]{0x55FF55}, new Integer[]{5}, SoundRegistry.FLIP_UNCOMMON, text -> text.withStyle(ChatFormatting.GREEN)),
    RARE(new Integer[]{0x5555FF}, new Integer[]{5}, SoundRegistry.FLIP_RARE, text -> text.withStyle(ChatFormatting.BLUE)),
    EPIC(new Integer[]{0xAA00AA}, new Integer[]{5}, SoundRegistry.FLIP_EPIC, text -> text.withStyle(ChatFormatting.DARK_PURPLE)),
    LEGENDARY(new Integer[]{0xFFAA00}, new Integer[]{5}, SoundRegistry.FLIP_LEGENDARY, text -> text.withStyle(ChatFormatting.GOLD)),
    MYTHICAL(new Integer[]{0xFF5555, 0xFFFFFF}, new Integer[]{5, 10}, SoundRegistry.FLIP_MYTHICAL, text -> text.withStyle(ChatFormatting.RED));

    private final Integer[] colors;
    private final Integer[] durations;
    private final Supplier<SoundEvent> flipSound;
    private final Component text;
    private final int value;

    private CardRarity(Integer[] colors, Integer[] durations, Supplier<SoundEvent> flipSound, UnaryOperator<MutableComponent> displayTextFormatter) {
        this.colors = colors;
        this.durations = durations;
        this.flipSound = flipSound;
        this.text = (Component)displayTextFormatter.apply(Component.translatable((String)("card.rarity." + this.name().toLowerCase(Locale.ROOT))));
        this.value = this.ordinal() + 1;
    }

    public Integer[] getColors() {
        return this.colors;
    }

    public Integer[] getDurations() {
        return this.durations;
    }

    public Supplier<SoundEvent> getFlipSoundRef() {
        return this.flipSound;
    }

    public Component getDisplayText() {
        return this.text;
    }

    public int getValue() {
        return this.value;
    }
}

