/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.card;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import team.tnt.collectorsalbum.common.AlbumCategory;
import team.tnt.collectorsalbum.common.card.AlbumCard;
import team.tnt.collectorsalbum.common.card.CardRarity;
import team.tnt.collectorsalbum.common.init.SoundRegistry;
import team.tnt.collectorsalbum.platform.Codecs;

public record CardUiTemplate(Integer[] effectColors, Integer[] effectDurations, Supplier<SoundEvent> flipSoundRef, ResourceLocation cardTexture) {
    public static final CardUiTemplate TEMPLATE = new CardUiTemplate(new Integer[]{65280}, new Integer[]{5}, SoundRegistry.FLIP_COMMON, null);
    public static final Codec<CardUiTemplate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codecs.array(Codec.INT, Integer[]::new).optionalFieldOf("effectColors", (Object)TEMPLATE.effectColors()).forGetter(t -> t.effectColors), (App)Codecs.array(Codec.INT, Integer[]::new).optionalFieldOf("effectDurations", (Object)TEMPLATE.effectDurations()).forGetter(t -> t.effectDurations), (App)Codecs.supplier(BuiltInRegistries.SOUND_EVENT.byNameCodec()).optionalFieldOf("flipSound", TEMPLATE.flipSoundRef()).forGetter(t -> t.flipSoundRef), (App)ResourceLocation.CODEC.optionalFieldOf("cardTexture").forGetter(t -> Optional.ofNullable(t.cardTexture))).apply((Applicative)instance, (colors, durations, sound, textureOpt) -> new CardUiTemplate((Integer[])colors, (Integer[])durations, (Supplier<SoundEvent>)sound, textureOpt.orElse(null)))).validate(template -> template.effectColors().length == template.effectDurations().length ? DataResult.success((Object)template) : DataResult.error(() -> "Effect duration count has to be the same as effect colors"));
    public static final Component DEFAULT_CARD_INFO_HEADER = Component.translatable((String)"collectorsalbum.tooltip.card.header").withStyle(ChatFormatting.GRAY);
    public static final String ITEM_TOOLTIP_NUMBER_KEY = "collectorsalbum.tooltip.card.number";
    public static final String ITEM_TOOLTIP_CATEGORY_KEY = "collectorsalbum.tooltip.card.category";
    public static final String ITEM_TOOLTIP_RARITY_KEY = "collectorsalbum.tooltip.card.rarity";
    public static final String ITEM_TOOLTIP_VALUE_KEY = "collectorsalbum.tooltip.card.value";
    public static final String INVALID_CATEGORY_KEY = "collectorsalbum.tooltip.card.category.invalid";

    public static MutableComponent getCardNumberTooltip(Component numberLabel) {
        return Component.translatable((String)ITEM_TOOLTIP_NUMBER_KEY, (Object[])new Object[]{numberLabel}).withStyle(ChatFormatting.GRAY);
    }

    public static MutableComponent getCardNumberTooltip(String prefix, int number) {
        MutableComponent label = Component.literal((String)(prefix + number)).withStyle(ChatFormatting.YELLOW);
        return CardUiTemplate.getCardNumberTooltip((Component)label);
    }

    public static MutableComponent getCardCategoryTooltip(AlbumCard card) {
        AlbumCategory category = card.getLinkedCategory();
        if (category == null) {
            MutableComponent categoryIdentifier = Component.literal((String)card.category().toString()).withStyle(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.RED});
            return Component.translatable((String)INVALID_CATEGORY_KEY, (Object[])new Object[]{categoryIdentifier}).withStyle(ChatFormatting.RED);
        }
        return CardUiTemplate.getCardCategoryTooltip(category);
    }

    public static MutableComponent getCardCategoryTooltip(AlbumCategory category) {
        return CardUiTemplate.getCardCategoryTooltip(category.getDisplayText());
    }

    public static MutableComponent getCardCategoryTooltip(Component categoryLabel) {
        return Component.translatable((String)ITEM_TOOLTIP_CATEGORY_KEY, (Object[])new Object[]{categoryLabel}).withStyle(ChatFormatting.GRAY);
    }

    public static MutableComponent getCardRarityTooltip(CardRarity rarity) {
        return CardUiTemplate.getCardRarityTooltip(rarity.getDisplayText());
    }

    public static MutableComponent getCardRarityTooltip(Component rarityLabel) {
        return Component.translatable((String)ITEM_TOOLTIP_RARITY_KEY, (Object[])new Object[]{rarityLabel}).withStyle(ChatFormatting.GRAY);
    }

    public static MutableComponent getCardPointsTooltip(AlbumCard card) {
        return CardUiTemplate.getCardPointsTooltip(card.getPoints());
    }

    public static MutableComponent getCardPointsTooltip(int points) {
        MutableComponent label = Component.translatable((String)"collectorsalbum.text.points.value", (Object[])new Object[]{points}).withStyle(ChatFormatting.YELLOW);
        return CardUiTemplate.getCardPointsTooltip((Component)label);
    }

    public static MutableComponent getCardPointsTooltip(Component pointsLabel) {
        return Component.translatable((String)ITEM_TOOLTIP_VALUE_KEY, (Object[])new Object[]{pointsLabel}).withStyle(ChatFormatting.GRAY);
    }
}

