/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.card;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import team.tnt.collectorsalbum.common.AlbumCategory;
import team.tnt.collectorsalbum.common.AlbumCategoryType;
import team.tnt.collectorsalbum.common.AlbumCategoryUiTemplate;
import team.tnt.collectorsalbum.common.card.AlbumCard;
import team.tnt.collectorsalbum.common.init.CategoryRegistry;
import team.tnt.collectorsalbum.common.resource.AlbumCardManager;
import team.tnt.collectorsalbum.platform.Codecs;

public class DefaultAlbumCategory
implements AlbumCategory {
    public static final MapCodec<DefaultAlbumCategory> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(DefaultAlbumCategory::identifier), (App)Codecs.setCodec(AlbumCardManager.BY_NAME_CODEC).fieldOf("cards").forGetter(t -> t.cards), (App)DisplayAttributes.CODEC.fieldOf("display").forGetter(t -> t.attributes), (App)AlbumCategoryUiTemplate.CODEC.optionalFieldOf("template", (Object)AlbumCategoryUiTemplate.DEFAULT_TEMPLATE).forGetter(t -> t.template)).apply((Applicative)instance, DefaultAlbumCategory::new));
    private final ResourceLocation identifier;
    private final Set<AlbumCard> cards;
    private final DisplayAttributes attributes;
    private final Component displayText;
    private final AlbumCategoryUiTemplate template;
    private final int[] uniqueCardNumbers;

    private DefaultAlbumCategory(ResourceLocation identifier, Set<AlbumCard> cards, DisplayAttributes attributes, AlbumCategoryUiTemplate template) {
        this.identifier = identifier;
        this.cards = cards;
        this.attributes = attributes;
        ChatFormatting[] styles = attributes.styleList.toArray(new ChatFormatting[0]);
        this.displayText = attributes.translated() ? Component.translatable((String)attributes.displayString()).withStyle(styles) : Component.literal((String)attributes.displayString()).withStyle(styles);
        this.template = template;
        this.uniqueCardNumbers = this.cards.stream().mapToInt(AlbumCard::cardNumber).distinct().sorted().toArray();
    }

    @Override
    public ResourceLocation identifier() {
        return this.identifier;
    }

    @Override
    public Component getDisplayText() {
        return this.displayText;
    }

    @Override
    public AlbumCategoryUiTemplate visualTemplate() {
        return this.template;
    }

    @Override
    public int getPageOrder() {
        return this.attributes.pageOrder();
    }

    @Override
    public int[] getCardNumbers() {
        return this.uniqueCardNumbers;
    }

    @Override
    public AlbumCategoryType<?> getType() {
        return (AlbumCategoryType)CategoryRegistry.CATEGORY.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultAlbumCategory that = (DefaultAlbumCategory)o;
        return Objects.equals(this.identifier, that.identifier);
    }

    public int hashCode() {
        return Objects.hashCode(this.identifier);
    }

    public record DisplayAttributes(String displayString, boolean translated, List<ChatFormatting> styleList, int pageOrder) {
        public static final Codec<DisplayAttributes> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(DisplayAttributes::displayString), (App)Codec.BOOL.optionalFieldOf("translate", (Object)false).forGetter(DisplayAttributes::translated), (App)ChatFormatting.CODEC.listOf().optionalFieldOf("styles", Collections.emptyList()).forGetter(DisplayAttributes::styleList), (App)Codec.INT.optionalFieldOf("pageOrder", (Object)Integer.MAX_VALUE).forGetter(DisplayAttributes::pageOrder)).apply((Applicative)instance, DisplayAttributes::new));
    }
}

