/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.command;

import com.google.common.collect.ArrayListMultimap;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import team.tnt.collectorsalbum.common.Album;
import team.tnt.collectorsalbum.common.AlbumCategory;
import team.tnt.collectorsalbum.common.card.AlbumCard;
import team.tnt.collectorsalbum.common.init.ItemDataComponentRegistry;
import team.tnt.collectorsalbum.common.init.ItemRegistry;
import team.tnt.collectorsalbum.common.resource.AlbumCardManager;
import team.tnt.collectorsalbum.common.resource.AlbumCategoryManager;

public final class CollectorsAlbumCommand {
    private static final SimpleCommandExceptionType NOT_PLAYER = new SimpleCommandExceptionType((Message)Component.literal((String)"Command must be executed by player"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"album").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"giveCompleted").executes(CollectorsAlbumCommand::givePlayerCompletedAlbum)));
    }

    private static int givePlayerCompletedAlbum(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.getPlayer();
        if (player == null) {
            throw NOT_PLAYER.create();
        }
        UUID albumUUID = UUID.randomUUID();
        AlbumCategoryManager categoryManager = AlbumCategoryManager.getInstance();
        AlbumCardManager cardManager = AlbumCardManager.getInstance();
        Collection<AlbumCategory> registeredCategories = categoryManager.listCategories();
        HashMap<ResourceLocation, Set<AlbumCard>> byCategory = new HashMap<ResourceLocation, Set<AlbumCard>>();
        HashMap<ResourceLocation, NonNullList<ItemStack>> items = new HashMap<ResourceLocation, NonNullList<ItemStack>>();
        ArrayListMultimap cardItemMap = ArrayListMultimap.create();
        for (Map.Entry<Item, AlbumCard> entry : cardManager.getByItemMap().entrySet()) {
            ResourceLocation key = entry.getValue().category();
            cardItemMap.put((Object)key, (Object)new CardItem(entry.getValue(), entry.getKey()));
        }
        for (AlbumCategory category : registeredCategories) {
            HashSet<AlbumCard> cardSet = new HashSet<AlbumCard>();
            NonNullList inventory = NonNullList.withSize((int)category.getCardNumbers().length, (Object)ItemStack.EMPTY);
            Collection validCards = cardItemMap.get((Object)category.identifier());
            int slotIndex = 0;
            for (int number : category.getCardNumbers()) {
                CardItem cardHolder = validCards.stream().filter(holder -> holder.card.cardNumber() == number).max(Comparator.comparingInt(holder -> holder.card.getPoints())).orElse(null);
                if (cardHolder != null) {
                    inventory.set(slotIndex, (Object)new ItemStack((ItemLike)cardHolder.item));
                    cardSet.add(cardHolder.card);
                }
                ++slotIndex;
            }
            byCategory.put(category.identifier(), cardSet);
            items.put(category.identifier(), (NonNullList<ItemStack>)inventory);
        }
        Album album = new Album(albumUUID, byCategory, items);
        ItemStack albumItemStack = new ItemStack((ItemLike)ItemRegistry.ALBUM.get());
        albumItemStack.set((DataComponentType)ItemDataComponentRegistry.ALBUM.get(), (Object)album);
        player.addItem(albumItemStack);
        player.sendSystemMessage((Component)Component.literal((String)"Album generated"));
        return 0;
    }

    private record CardItem(AlbumCard card, Item item) {
    }
}

