/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.menu;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import team.tnt.collectorsalbum.CollectorsAlbum;
import team.tnt.collectorsalbum.common.Album;
import team.tnt.collectorsalbum.common.AlbumCategory;
import team.tnt.collectorsalbum.common.AlbumCategoryUiTemplate;
import team.tnt.collectorsalbum.common.card.AlbumCard;
import team.tnt.collectorsalbum.common.init.ItemDataComponentRegistry;
import team.tnt.collectorsalbum.common.init.MenuRegistry;
import team.tnt.collectorsalbum.common.menu.AlbumRestrictedSlot;
import team.tnt.collectorsalbum.common.resource.AlbumCardManager;
import team.tnt.collectorsalbum.common.resource.AlbumCategoryManager;

public class AlbumCategoryMenu
extends AbstractContainerMenu {
    private ResourceLocation category;
    private final Int2IntMap cardNumberToSlotCache = new Int2IntOpenHashMap();

    public AlbumCategoryMenu(int menuId, Inventory inventory) {
        super((MenuType)MenuRegistry.ALBUM_CATEGORY.get(), menuId);
    }

    public AlbumCategoryMenu(int menuId, Inventory playerInventory, ResourceLocation category) {
        this(menuId, playerInventory);
        this.category = category;
        ItemStack itemStack = playerInventory.player.getMainHandItem();
        Album album = (Album)itemStack.get((DataComponentType)ItemDataComponentRegistry.ALBUM.get());
        if (album == null) {
            return;
        }
        AlbumCategoryManager manager = AlbumCategoryManager.getInstance();
        AlbumCategory albumCategory = manager.findById(category).orElse(null);
        if (albumCategory != null) {
            int x;
            int y;
            AlbumCategoryUiTemplate template = albumCategory.visualTemplate();
            AlbumCategoryUiTemplate.SlotPositionTemplate slotTemplate = template.slotTemplate;
            int xStart = slotTemplate.xAlbumSlotPositionStart();
            int yStart = slotTemplate.yAlbumSlotPositionStart();
            int xSpacing = slotTemplate.xSlotSpacing();
            int ySpacing = slotTemplate.ySlotSpacing();
            int pageWidth = slotTemplate.pageWidth();
            int[] cardNumbers = albumCategory.getCardNumbers();
            int slotsPerPage = slotTemplate.columns() * slotTemplate.rows();
            AlbumInventoryWrapper wrapper = new AlbumInventoryWrapper(cardNumbers.length, itemStack, category, album);
            block0: for (int y2 = 0; y2 < slotTemplate.rows(); ++y2) {
                for (int x2 = 0; x2 < slotTemplate.columns(); ++x2) {
                    int cardX = xStart + x2 * xSpacing;
                    int cardY = yStart + y2 * ySpacing;
                    int cardIndex = x2 + y2 * slotTemplate.columns();
                    if (cardIndex >= cardNumbers.length) continue block0;
                    this.addSlot(new CardSlot((Container)wrapper, cardIndex, cardX, cardY, category, cardNumbers[cardIndex]));
                    this.cardNumberToSlotCache.put(cardNumbers[cardIndex], cardIndex);
                }
            }
            if (cardNumbers.length >= slotsPerPage) {
                int cardsLength = slotTemplate.columns() * xSpacing - xSpacing;
                int rightStartX = pageWidth * 2 - 18 - cardsLength - xStart + 2;
                block2: for (y = 0; y < slotTemplate.rows(); ++y) {
                    for (x = 0; x < slotTemplate.columns(); ++x) {
                        int cardX = rightStartX + x * xSpacing;
                        int cardY = yStart + y * ySpacing;
                        int cardIndex = slotsPerPage + x + y * slotTemplate.columns();
                        if (cardIndex >= cardNumbers.length) continue block2;
                        this.addSlot(new CardSlot((Container)wrapper, cardIndex, cardX, cardY, category, cardNumbers[cardIndex]));
                        this.cardNumberToSlotCache.put(cardNumbers[cardIndex], cardIndex);
                    }
                }
            }
            int playerX = slotTemplate.xPlayerSlotPositionStart();
            int playerY = slotTemplate.yPlayerSlotPositionStart();
            for (y = 0; y < 3; ++y) {
                for (x = 0; x < 9; ++x) {
                    this.addSlot(new AlbumRestrictedSlot((Container)playerInventory, 9 + x + y * 9, playerX + 1 + x * 18, playerY + 1 + y * 18));
                }
            }
            for (int x3 = 0; x3 < 9; ++x3) {
                this.addSlot(new AlbumRestrictedSlot((Container)playerInventory, x3, playerX + 1 + x3 * 18, playerY + 59));
            }
        }
    }

    public void removed(Player player) {
        super.removed(player);
        CollectorsAlbum.forceAlbumReload(player);
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotItem = slot.getItem();
            itemStack = slotItem.copy();
            AlbumCategoryManager manager = AlbumCategoryManager.getInstance();
            int slotsCount = manager.findById(this.category).map(cat -> cat.getCardNumbers().length).orElse(0);
            if (slotsCount == 0) {
                return this.transferInInventory(slotItem, index, 0);
            }
            if (index >= 0 && index < slotsCount) {
                if (!this.moveItemStackTo(slotItem, slotsCount, slotsCount + 36, true)) {
                    return ItemStack.EMPTY;
                }
                slot.setChanged();
            } else if (index >= slotsCount && index < slotsCount + 36) {
                AlbumCard albumCard = this.getCardInfo(slotItem);
                if (albumCard == null || !albumCard.category().equals((Object)this.category)) {
                    return this.transferInInventory(slotItem, index, slotsCount);
                }
                int cardNumber = albumCard.cardNumber();
                if (!this.cardNumberToSlotCache.containsKey(cardNumber)) {
                    return this.transferInInventory(slotItem, index, slotsCount);
                }
                int cardSlot = this.cardNumberToSlotCache.get(cardNumber);
                Slot targetSlot = (Slot)this.slots.get(cardSlot);
                if (slotItem.getCount() > 1) {
                    if (!targetSlot.hasItem()) {
                        itemStack = slotItem.copy();
                        itemStack.setCount(1);
                        targetSlot.set(itemStack);
                        slotItem.shrink(1);
                        return slotItem;
                    }
                    return ItemStack.EMPTY;
                }
                AlbumCard replacement = null;
                if (targetSlot.hasItem()) {
                    ItemStack inSlot = targetSlot.getItem();
                    replacement = this.getCardInfo(inSlot);
                }
                if (replacement == null || albumCard.compareTo(replacement) > 0) {
                    itemStack = targetSlot.getItem().copy();
                    targetSlot.set(slotItem);
                    slot.set(itemStack.copy());
                }
            }
        }
        return ItemStack.EMPTY;
    }

    public AlbumCategory getCategory() {
        if (this.category == null) {
            throw new IllegalStateException("Category is not defined");
        }
        AlbumCategoryManager manager = AlbumCategoryManager.getInstance();
        return manager.findById(this.category).orElseThrow();
    }

    private ItemStack transferInInventory(ItemStack itemStack, int index, int cards) {
        if (index >= cards && index < cards + 27 ? !this.moveItemStackTo(itemStack, cards + 27, cards + 36, false) : index >= cards + 27 && index < cards + 36 && !this.moveItemStackTo(itemStack, cards, cards + 9, false)) {
            return ItemStack.EMPTY;
        }
        return itemStack;
    }

    private AlbumCard getCardInfo(ItemStack itemStack) {
        return AlbumCardManager.getInstance().getCardInfo(itemStack.getItem()).orElse(null);
    }

    private static final class AlbumInventoryWrapper
    extends SimpleContainer {
        private final ItemStack itemStack;
        private final ResourceLocation category;

        AlbumInventoryWrapper(int size, ItemStack itemStack, ResourceLocation category, Album album) {
            super(size);
            this.itemStack = itemStack;
            this.category = category;
            NonNullList<ItemStack> itemStacks = album.getInventory(category);
            for (int i = 0; i < itemStacks.size(); ++i) {
                ItemStack stack = (ItemStack)itemStacks.get(i);
                if (stack.isEmpty()) continue;
                this.getItems().set(i, (Object)stack.copy());
            }
        }

        public void setItem(int index, ItemStack itemStack) {
            Album album = (Album)this.itemStack.get((DataComponentType)ItemDataComponentRegistry.ALBUM.get());
            if (album != null) {
                Album.Mutable mutable = new Album.Mutable(album);
                mutable.set(this.category, index, itemStack.copy());
                Album updated = mutable.toImmutable();
                this.itemStack.set((DataComponentType)ItemDataComponentRegistry.ALBUM.get(), (Object)updated);
            }
            super.setItem(index, itemStack);
        }

        public void setChanged() {
            Album album = (Album)this.itemStack.get((DataComponentType)ItemDataComponentRegistry.ALBUM.get());
            if (album != null) {
                NonNullList itemStacks = this.getItems();
                Album.Mutable mutableAlbum = new Album.Mutable(album);
                for (int i = 0; i < itemStacks.size(); ++i) {
                    ItemStack stack = (ItemStack)itemStacks.get(i);
                    mutableAlbum.set(this.category, i, stack.copy());
                }
                this.itemStack.set((DataComponentType)ItemDataComponentRegistry.ALBUM.get(), (Object)mutableAlbum.toImmutable());
            }
            super.setChanged();
        }
    }

    private static final class CardSlot
    extends Slot {
        private final ResourceLocation category;
        private final int cardNumber;

        public CardSlot(Container container, int index, int slotX, int slotY, ResourceLocation category, int number) {
            super(container, index, slotX, slotY);
            this.category = category;
            this.cardNumber = number;
        }

        public boolean mayPlace(ItemStack itemStack) {
            AlbumCardManager manager = AlbumCardManager.getInstance();
            return manager.getCardInfo(itemStack.getItem()).map(info -> {
                ResourceLocation cardCategory = info.category();
                int cardNumber = info.cardNumber();
                return cardNumber == this.cardNumber && cardCategory.equals((Object)this.category);
            }).orElse(false);
        }

        public int getMaxStackSize() {
            return 1;
        }

        public int getMaxStackSize(ItemStack $$0) {
            return this.getMaxStackSize();
        }
    }
}

