/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.resource;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import team.tnt.collectorsalbum.common.card.AlbumCard;
import team.tnt.collectorsalbum.common.card.AlbumCardType;
import team.tnt.collectorsalbum.common.resource.SynchronizedResource;
import team.tnt.collectorsalbum.platform.resource.PlatformGsonCodecReloadListener;

public class AlbumCardManager
extends PlatformGsonCodecReloadListener<AlbumCard>
implements SynchronizedResource<AlbumCard> {
    private static final ResourceLocation IDENTIFIER = ResourceLocation.fromNamespaceAndPath((String)"collectorsalbum", (String)"album_card_manager");
    private static final AlbumCardManager INSTANCE = new AlbumCardManager();
    public static final Codec<AlbumCard> BY_NAME_CODEC = ResourceLocation.CODEC.comapFlatMap(identifier -> {
        AlbumCard card = AlbumCardManager.INSTANCE.registeredCards.get(identifier);
        return card != null ? DataResult.success((Object)card) : DataResult.error(() -> "Unknown card: " + String.valueOf(identifier));
    }, AlbumCard::identifier);
    private final Map<ResourceLocation, AlbumCard> registeredCards = new HashMap<ResourceLocation, AlbumCard>();
    private final Map<Item, AlbumCard> byItemMap = new HashMap<Item, AlbumCard>();

    private AlbumCardManager() {
        super("album/cards", AlbumCardType.INSTANCE_CODEC);
    }

    public static AlbumCardManager getInstance() {
        return INSTANCE;
    }

    public Optional<AlbumCard> getCardInfo(Item item) {
        return Optional.ofNullable(this.byItemMap.get(item));
    }

    public AlbumCard getCardById(ResourceLocation location) {
        return this.registeredCards.get(location);
    }

    public boolean isCard(Item item) {
        return this.byItemMap.containsKey(item);
    }

    public boolean isCard(ItemStack itemStack) {
        return this.isCard(itemStack.getItem());
    }

    @Override
    public ResourceLocation identifier() {
        return IDENTIFIER;
    }

    public List<ItemStack> processDrops(List<ItemStack> drops) {
        return drops.stream().filter(this::isCard).map(ItemStack::copy).collect(Collectors.toList());
    }

    public Map<Item, AlbumCard> getByItemMap() {
        return Collections.unmodifiableMap(this.byItemMap);
    }

    @Override
    protected void preApply(Map<ResourceLocation, JsonElement> resources, ResourceManager manager, ProfilerFiller profiler) {
        this.registeredCards.clear();
        this.byItemMap.clear();
    }

    @Override
    protected void resolve(ResourceLocation path, AlbumCard element) {
        if (!element.enabled()) {
            return;
        }
        if (this.registeredCards.putIfAbsent(element.identifier(), element) != null) {
            throw new IllegalArgumentException("Duplicate card with ID: " + String.valueOf(element.identifier()));
        }
        ItemStack itemStack = element.asItem();
        Item item = itemStack.getItem();
        if (this.byItemMap.putIfAbsent(item, element) != null) {
            throw new IllegalArgumentException(String.format("Duplicate item registered as a card in %s and %s cards", path.toString(), this.byItemMap.get(item).identifier()));
        }
    }

    @Override
    public List<AlbumCard> getDataForSync() {
        return new ArrayList<AlbumCard>(this.registeredCards.values());
    }

    @Override
    public synchronized void receiveNetworkData(List<AlbumCard> collection) {
        this.registeredCards.clear();
        this.byItemMap.clear();
        collection.forEach(card -> {
            this.registeredCards.put(card.identifier(), (AlbumCard)card);
            this.byItemMap.put(card.asItem().getItem(), (AlbumCard)card);
        });
    }
}

