/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.resource;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import team.tnt.collectorsalbum.common.AlbumCategory;
import team.tnt.collectorsalbum.common.AlbumCategoryType;
import team.tnt.collectorsalbum.common.resource.SynchronizedResource;
import team.tnt.collectorsalbum.platform.resource.PlatformGsonCodecReloadListener;

public final class AlbumCategoryManager
extends PlatformGsonCodecReloadListener<AlbumCategory>
implements SynchronizedResource<AlbumCategory> {
    private static final ResourceLocation IDENTIFIER = ResourceLocation.fromNamespaceAndPath((String)"collectorsalbum", (String)"album_category_manager");
    private static final AlbumCategoryManager INSTANCE = new AlbumCategoryManager();
    private final Map<ResourceLocation, AlbumCategory> registeredCategories = new HashMap<ResourceLocation, AlbumCategory>();
    private final List<AlbumCategory> pagedCategories = new ArrayList<AlbumCategory>();

    private AlbumCategoryManager() {
        super("album/categories", AlbumCategoryType.INSTANCE_CODEC);
    }

    public static AlbumCategoryManager getInstance() {
        return INSTANCE;
    }

    public AlbumCategory getCategoryForPage(int page) {
        return page >= 0 && page < this.pagedCategories.size() ? this.pagedCategories.get(page) : null;
    }

    public int getPageForCategory(AlbumCategory category) {
        return this.pagedCategories.indexOf(category);
    }

    public List<AlbumCategory> listBookmarkableCategories() {
        return this.pagedCategories.stream().filter(cat -> !cat.visualTemplate().bookmarkIcon.isEmpty()).toList();
    }

    public int getCollectibleCardCount() {
        return this.pagedCategories.stream().mapToInt(category -> category.getCardNumbers().length).sum();
    }

    public Collection<AlbumCategory> listCategories() {
        return this.registeredCategories.values();
    }

    @Override
    public ResourceLocation identifier() {
        return IDENTIFIER;
    }

    public Optional<AlbumCategory> findById(ResourceLocation id) {
        return Optional.ofNullable(this.registeredCategories.get(id));
    }

    @Override
    protected void preApply(Map<ResourceLocation, JsonElement> resources, ResourceManager manager, ProfilerFiller profiler) {
        this.registeredCategories.clear();
        this.pagedCategories.clear();
    }

    @Override
    protected void resolve(ResourceLocation path, AlbumCategory element) {
        if (element.getCardNumbers().length == 0) {
            return;
        }
        if (this.registeredCategories.putIfAbsent(element.identifier(), element) != null) {
            throw new IllegalArgumentException("Duplicate card category: " + String.valueOf(element.identifier()));
        }
    }

    @Override
    protected void onReloadComplete(ResourceManager manager, ProfilerFiller profiler) {
        super.onReloadComplete(manager, profiler);
        this.registeredCategories.values().stream().sorted(Comparator.comparingInt(AlbumCategory::getPageOrder)).forEach(this.pagedCategories::add);
    }

    @Override
    public List<AlbumCategory> getDataForSync() {
        return new ArrayList<AlbumCategory>(this.registeredCategories.values());
    }

    @Override
    public synchronized void receiveNetworkData(List<AlbumCategory> collection) {
        this.registeredCategories.clear();
        this.pagedCategories.clear();
        collection.forEach(category -> this.registeredCategories.put(category.identifier(), (AlbumCategory)category));
        this.pagedCategories.addAll(collection.stream().sorted(Comparator.comparingInt(AlbumCategory::getPageOrder)).toList());
    }
}

