/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.resource;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import team.tnt.collectorsalbum.common.resource.SynchronizedResource;
import team.tnt.collectorsalbum.common.resource.drops.ItemDropProvider;
import team.tnt.collectorsalbum.common.resource.drops.ItemDropProviderType;
import team.tnt.collectorsalbum.common.resource.drops.ItemDropResourceManager;
import team.tnt.collectorsalbum.common.resource.drops.NoItemDropProvider;
import team.tnt.collectorsalbum.platform.resource.PlatformGsonCodecReloadListener;

public class CardPackDropManager
extends PlatformGsonCodecReloadListener<ItemDropProvider>
implements ItemDropResourceManager,
SynchronizedResource<DropEntry> {
    private static final CardPackDropManager INSTANCE = new CardPackDropManager();
    private static final ResourceLocation IDENTIFIER = ResourceLocation.fromNamespaceAndPath((String)"collectorsalbum", (String)"card_pack_drops");
    private final Map<ResourceLocation, ItemDropProvider> providerMap = new HashMap<ResourceLocation, ItemDropProvider>();

    private CardPackDropManager() {
        super("album/packs", ItemDropProviderType.INSTANCE_CODEC);
    }

    public static CardPackDropManager getInstance() {
        return INSTANCE;
    }

    @Override
    public ItemDropProvider getProvider(ResourceLocation id) {
        return this.providerMap.getOrDefault(id, NoItemDropProvider.INSTANCE);
    }

    public ItemDropProvider getEitherProvider(ResourceLocation main, ResourceLocation secondary) {
        return this.providerMap.getOrDefault(main, this.getProvider(secondary));
    }

    @Override
    public ResourceLocation identifier() {
        return IDENTIFIER;
    }

    @Override
    protected void preApply(Map<ResourceLocation, JsonElement> resources, ResourceManager manager, ProfilerFiller profiler) {
        this.providerMap.clear();
    }

    @Override
    protected void resolve(ResourceLocation path, ItemDropProvider element) {
        this.providerMap.put(path, element);
    }

    @Override
    public List<DropEntry> getDataForSync() {
        return this.providerMap.entrySet().stream().map(entry -> new DropEntry((ResourceLocation)entry.getKey(), (ItemDropProvider)entry.getValue())).collect(Collectors.toList());
    }

    @Override
    public synchronized void receiveNetworkData(List<DropEntry> data) {
        this.providerMap.clear();
        data.forEach(entry -> this.providerMap.put(entry.id, entry.provider));
    }

    public record DropEntry(ResourceLocation id, ItemDropProvider provider) {
        public static final Codec<DropEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(DropEntry::id), (App)ItemDropProviderType.INSTANCE_CODEC.fieldOf("provider").forGetter(DropEntry::provider)).apply((Applicative)instance, DropEntry::new));
    }
}

