/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.resource.bonus;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import team.tnt.collectorsalbum.common.Album;
import team.tnt.collectorsalbum.common.AlbumBonusDescriptionOutput;
import team.tnt.collectorsalbum.common.AlbumCategory;
import team.tnt.collectorsalbum.common.CommonLabels;
import team.tnt.collectorsalbum.common.card.AlbumCard;
import team.tnt.collectorsalbum.common.card.CardCategoryFilter;
import team.tnt.collectorsalbum.common.init.AlbumBonusRegistry;
import team.tnt.collectorsalbum.common.resource.AlbumCategoryManager;
import team.tnt.collectorsalbum.common.resource.bonus.AlbumBonus;
import team.tnt.collectorsalbum.common.resource.bonus.AlbumBonusType;
import team.tnt.collectorsalbum.common.resource.bonus.IntermediateAlbumBonus;
import team.tnt.collectorsalbum.common.resource.util.ActionContext;

public class AlbumCategoryCardBonusFilter
implements IntermediateAlbumBonus {
    public static final Component UNKNOWN_CATEGORY_LABEL = Component.translatable((String)"collectorsalbum.label.unknown").withStyle(ChatFormatting.RED);
    public static final String MATCHED = "collectorsalbum.label.bonus.matched_cards";
    public static final MapCodec<AlbumCategoryCardBonusFilter> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("category").forGetter(t -> t.category), (App)CardCategoryFilter.CODEC.optionalFieldOf("filter", (Object)CardCategoryFilter.NO_FILTER).forGetter(t -> t.filter), (App)AlbumBonusType.INSTANCE_CODEC.fieldOf("item").forGetter(t -> t.item)).apply((Applicative)instance, AlbumCategoryCardBonusFilter::new));
    private final ResourceLocation category;
    private final CardCategoryFilter filter;
    private final AlbumBonus item;

    public AlbumCategoryCardBonusFilter(ResourceLocation category, CardCategoryFilter filter, AlbumBonus item) {
        this.category = category;
        this.filter = filter;
        this.item = item;
    }

    @Override
    public void addDescription(AlbumBonusDescriptionOutput description) {
        Component categoryDisplayLabel = AlbumCategoryManager.getInstance().findById(this.category).map(AlbumCategory::getDisplayText).orElse(UNKNOWN_CATEGORY_LABEL);
        MutableComponent categoryIdentifierLabel = Component.literal((String)this.category.toString());
        description.text((Component)Component.translatable((String)"collectorsalbum.tooltip.card.category", (Object[])new Object[]{categoryDisplayLabel}), (Component)categoryIdentifierLabel);
        description.nested(() -> {
            if (this.filter != CardCategoryFilter.NO_FILTER) {
                description.text(CardCategoryFilter.LABEL_FILTER);
                description.nested(() -> this.filter.generateDescriptionLabels(description));
            }
            boolean canApply = this.canApply(description.getContext());
            MutableComponent matchingCards = Component.literal((String)String.valueOf(this.getMatchingCards(description.getContext()).size())).withStyle(AlbumBonusDescriptionOutput.getBooleanColor(canApply));
            MutableComponent matched = Component.translatable((String)MATCHED, (Object[])new Object[]{matchingCards});
            description.text((Component)matched, this.filter.cardCountFilter().getDisplayComponent());
            description.condition(CommonLabels.APPLIES, CommonLabels.getBoolState(canApply), canApply, this);
        });
    }

    @Override
    public void apply(ActionContext context) {
        if (this.canApply(context)) {
            this.item.apply(context);
        } else {
            this.item.removed(context);
        }
    }

    @Override
    public void removed(ActionContext context) {
        this.item.removed(context);
    }

    @Override
    public List<AlbumBonus> children() {
        return Collections.singletonList(this.item);
    }

    @Override
    public AlbumBonusType<?> getType() {
        return (AlbumBonusType)AlbumBonusRegistry.CATEGORY_FILTER.get();
    }

    @Override
    public boolean canApply(ActionContext context) {
        List<AlbumCard> matching = this.getMatchingCards(context);
        int categoryValue = matching.stream().mapToInt(AlbumCard::getPoints).sum();
        return this.filter.categoryPointFilter().test(categoryValue) && this.filter.cardCountFilter().test(matching.size());
    }

    private List<AlbumCard> getMatchingCards(ActionContext context) {
        return context.get("album", Album.class).map(album -> {
            Collection<AlbumCard> cards = album.getCardsForCategory(this.category);
            return cards.stream().filter(card -> card.test(this.filter)).toList();
        }).orElse(Collections.emptyList());
    }
}

