/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.resource.bonus;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.network.chat.Component;
import team.tnt.collectorsalbum.common.AlbumBonusDescriptionOutput;
import team.tnt.collectorsalbum.common.init.AlbumBonusRegistry;
import team.tnt.collectorsalbum.common.resource.bonus.AlbumBonus;
import team.tnt.collectorsalbum.common.resource.bonus.AlbumBonusType;
import team.tnt.collectorsalbum.common.resource.bonus.IntermediateAlbumBonus;
import team.tnt.collectorsalbum.common.resource.util.ActionContext;

public class FirstApplicableBonus
implements IntermediateAlbumBonus {
    public static final Component LABEL = Component.translatable((String)"collectorsalbum.label.bonus.first_applicable");
    public static final Component TOOLTIP = Component.translatable((String)"collectorsalbum.tooltip.bonus.first_applicable");
    public static final MapCodec<FirstApplicableBonus> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)AlbumBonusType.INSTANCE_CODEC.listOf().fieldOf("items").forGetter(t -> t.items)).apply((Applicative)instance, FirstApplicableBonus::new));
    private final List<AlbumBonus> items;

    public FirstApplicableBonus(List<AlbumBonus> items) {
        this.items = items;
    }

    @Override
    public void addDescription(AlbumBonusDescriptionOutput description) {
        description.list(LABEL, TOOLTIP, this);
    }

    @Override
    public boolean canApply(ActionContext context) {
        for (AlbumBonus item : this.items) {
            IntermediateAlbumBonus intermediateAlbumBonus;
            if (item instanceof IntermediateAlbumBonus && !(intermediateAlbumBonus = (IntermediateAlbumBonus)item).canApply(context)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void apply(ActionContext context) {
        for (AlbumBonus bonus : this.items) {
            IntermediateAlbumBonus intermediateAlbumBonus;
            if (!(bonus instanceof IntermediateAlbumBonus) || (intermediateAlbumBonus = (IntermediateAlbumBonus)bonus).canApply(context)) {
                bonus.apply(context);
                break;
            }
            bonus.removed(context);
        }
    }

    @Override
    public void removed(ActionContext context) {
        this.items.forEach(item -> item.removed(context));
    }

    @Override
    public List<AlbumBonus> children() {
        return this.items;
    }

    @Override
    public AlbumBonusType<?> getType() {
        return (AlbumBonusType)AlbumBonusRegistry.FIRST_APPLICABLE.get();
    }
}

