/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.resource.drops;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import team.tnt.collectorsalbum.CollectorsAlbum;
import team.tnt.collectorsalbum.common.init.ItemDropProviderRegistry;
import team.tnt.collectorsalbum.common.resource.drops.ItemDropProvider;
import team.tnt.collectorsalbum.common.resource.drops.ItemDropProviderType;
import team.tnt.collectorsalbum.common.resource.drops.NoItemDropProvider;
import team.tnt.collectorsalbum.common.resource.util.ActionContext;
import team.tnt.collectorsalbum.common.resource.util.OutputBuilder;

public class EntityFilterItemDropProvider
implements ItemDropProvider {
    public static final MapCodec<EntityFilterItemDropProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TagKey.codec((ResourceKey)Registries.ENTITY_TYPE).fieldOf("filter").forGetter(t -> t.filter), (App)ItemDropProviderType.INSTANCE_CODEC.fieldOf("pass").forGetter(t -> t.pass), (App)ItemDropProviderType.INSTANCE_CODEC.optionalFieldOf("fail", (Object)NoItemDropProvider.INSTANCE).forGetter(t -> t.fail), (App)Codec.BOOL.optionalFieldOf("blacklist", (Object)false).forGetter(t -> t.blacklist)).apply((Applicative)instance, EntityFilterItemDropProvider::new));
    private final TagKey<EntityType<?>> filter;
    private final ItemDropProvider pass;
    private final ItemDropProvider fail;
    private final boolean blacklist;

    public EntityFilterItemDropProvider(TagKey<EntityType<?>> filter, ItemDropProvider pass, ItemDropProvider fail, boolean blacklist) {
        this.filter = filter;
        this.pass = pass;
        this.fail = fail;
        this.blacklist = blacklist;
    }

    @Override
    public void generateDrops(ActionContext context, OutputBuilder<ItemStack> output) {
        ItemDropProvider fail;
        Entity entity = context.getNullable("entity", Entity.class);
        if (entity == null) {
            CollectorsAlbum.LOGGER.warn("Failed to generate item drop, 'entity' key is not found in drop context!");
            return;
        }
        EntityType entityType = entity.getType();
        ItemDropProvider pass = this.blacklist ? this.fail : this.pass;
        ItemDropProvider itemDropProvider = fail = this.blacklist ? this.pass : this.fail;
        if (entityType.is(this.filter)) {
            pass.generateDrops(context, output);
        } else {
            fail.generateDrops(context, output);
        }
    }

    @Override
    public ItemDropProviderType<?> getType() {
        return (ItemDropProviderType)ItemDropProviderRegistry.ENTITY_FILTER.get();
    }

    @Override
    public Stream<ItemStack> view() {
        return Stream.empty();
    }
}

