/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.resource.drops;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import team.tnt.collectorsalbum.common.init.ItemDropProviderRegistry;
import team.tnt.collectorsalbum.common.resource.drops.ItemDropProvider;
import team.tnt.collectorsalbum.common.resource.drops.ItemDropProviderType;
import team.tnt.collectorsalbum.common.resource.function.ConstantNumberProvider;
import team.tnt.collectorsalbum.common.resource.function.NumberProvider;
import team.tnt.collectorsalbum.common.resource.function.NumberProviderType;
import team.tnt.collectorsalbum.common.resource.util.ActionContext;
import team.tnt.collectorsalbum.common.resource.util.OutputBuilder;
import team.tnt.collectorsalbum.platform.Codecs;

public class RandomChanceFilterItemDropProvider
implements ItemDropProvider {
    public static final MapCodec<RandomChanceFilterItemDropProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.either(Codecs.PERCENT_FLOAT, NumberProviderType.INSTANCE_CODEC).fieldOf("chance").forGetter(t -> Either.right((Object)t.chance)), (App)ItemDropProviderType.INSTANCE_CODEC.fieldOf("item").forGetter(t -> t.item)).apply((Applicative)instance, RandomChanceFilterItemDropProvider::new));
    private final NumberProvider chance;
    private final ItemDropProvider item;

    public RandomChanceFilterItemDropProvider(Either<Float, NumberProvider> chance, ItemDropProvider item) {
        this.chance = (NumberProvider)chance.map(ConstantNumberProvider::new, Function.identity());
        this.item = item;
    }

    @Override
    public void generateDrops(ActionContext context, OutputBuilder<ItemStack> output) {
        float chance;
        RandomSource source = context.getOrThrow("random", RandomSource.class);
        float roll = source.nextFloat();
        if (roll < (chance = this.chance.floatValue())) {
            this.item.generateDrops(context, output);
        }
    }

    @Override
    public ItemDropProviderType<?> getType() {
        return (ItemDropProviderType)ItemDropProviderRegistry.RANDOM_CHANCE.get();
    }

    @Override
    public Stream<ItemStack> view() {
        return this.chance.floatValue() > 0.0f ? this.item.view() : Stream.empty();
    }
}

