/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.resource.drops;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import team.tnt.collectorsalbum.CollectorsAlbum;
import team.tnt.collectorsalbum.common.init.ItemDropProviderRegistry;
import team.tnt.collectorsalbum.common.resource.drops.ItemDropProvider;
import team.tnt.collectorsalbum.common.resource.drops.ItemDropProviderType;
import team.tnt.collectorsalbum.common.resource.function.ConstantNumberProvider;
import team.tnt.collectorsalbum.common.resource.function.NumberProvider;
import team.tnt.collectorsalbum.common.resource.function.NumberProviderType;
import team.tnt.collectorsalbum.common.resource.util.ActionContext;
import team.tnt.collectorsalbum.common.resource.util.OutputBuilder;
import team.tnt.collectorsalbum.util.TagHelper;

public class TagDropProvider
implements ItemDropProvider {
    public static final MapCodec<TagDropProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TagKey.codec((ResourceKey)Registries.ITEM).fieldOf("tag").forGetter(t -> t.tagKey), (App)Codec.either((Codec)ExtraCodecs.POSITIVE_INT, NumberProviderType.INSTANCE_CODEC).optionalFieldOf("count", (Object)Either.left((Object)1)).forGetter(t -> Either.right((Object)t.size))).apply((Applicative)instance, TagDropProvider::new));
    private final TagKey<Item> tagKey;
    private final NumberProvider size;

    public TagDropProvider(TagKey<Item> tagKey, Either<Integer, NumberProvider> size) {
        this.tagKey = tagKey;
        this.size = (NumberProvider)size.map(ConstantNumberProvider::new, Function.identity());
    }

    @Override
    public void generateDrops(ActionContext context, OutputBuilder<ItemStack> output) {
        RandomSource random = context.getOrThrow("random", RandomSource.class);
        Item item = TagHelper.getRandomTagValue(this.tagKey, BuiltInRegistries.ITEM, random);
        if (item != null) {
            int sizeUpperBound = item.getDefaultMaxStackSize();
            int itemSize = Mth.clamp((int)this.size.intValue(), (int)1, (int)sizeUpperBound);
            output.accept(new ItemStack((ItemLike)item, itemSize));
        } else {
            CollectorsAlbum.LOGGER.warn("Failed to obtain items for tag {} for drop generation", this.tagKey);
        }
    }

    @Override
    public ItemDropProviderType<?> getType() {
        return (ItemDropProviderType)ItemDropProviderRegistry.TAG_DROP_PROVIDER.get();
    }

    @Override
    public Stream<ItemStack> view() {
        return TagHelper.getTagValues(this.tagKey, BuiltInRegistries.ITEM).stream().map(Item::getDefaultInstance);
    }
}

