/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.resource.function;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.function.Function;
import team.tnt.collectorsalbum.common.init.NumberProviderRegistry;
import team.tnt.collectorsalbum.common.resource.function.NumberProvider;
import team.tnt.collectorsalbum.common.resource.function.NumberProviderType;

public class RandomNumberProvider
implements NumberProvider {
    public static final MapCodec<RandomNumberProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.DOUBLE.fieldOf("min").forGetter(t -> t.min), (App)Codec.DOUBLE.fieldOf("max").forGetter(t -> t.max)).apply((Applicative)instance, RandomNumberProvider::new)).validate(o -> o.min > o.max ? DataResult.error(() -> "Min value cannot be larger than max value!") : DataResult.success((Object)o));
    private static final Random RANDOM = new Random();
    private final double min;
    private final double max;

    public RandomNumberProvider(double min, double max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public <N extends Number> N getNumber(Function<Number, N> mapper) {
        double delta = this.max - this.min;
        double randomBetween = this.min + delta * RANDOM.nextDouble();
        return (N)((Number)mapper.apply(randomBetween));
    }

    @Override
    public NumberProviderType<?> getType() {
        return (NumberProviderType)NumberProviderRegistry.RANDOM.get();
    }
}

