/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.integrations.jei;

import java.util.HashSet;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawablesView;
import mezz.jei.api.gui.placement.HorizontalAlignment;
import mezz.jei.api.gui.placement.VerticalAlignment;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IScrollGridWidget;
import mezz.jei.api.gui.widgets.ITextWidget;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import team.tnt.collectorsalbum.common.init.ItemRegistry;
import team.tnt.collectorsalbum.common.resource.CardPackDropManager;
import team.tnt.collectorsalbum.integrations.jei.JeiIntegrationPlugin;

public class CardPackDropRecipeCategory
implements IRecipeCategory<CardPackDropManager.DropEntry> {
    public static final Component TITLE = Component.translatable((String)"collectorsalbum.label.jei.pack_drop.title");
    private final IJeiHelpers helpers;
    private final IDrawable icon;

    public CardPackDropRecipeCategory(IJeiHelpers helpers) {
        this.helpers = helpers;
        this.icon = helpers.getGuiHelper().createDrawableItemLike((ItemLike)ItemRegistry.MYTHICAL_CARD_PACK.get());
    }

    public RecipeType<CardPackDropManager.DropEntry> getRecipeType() {
        return JeiIntegrationPlugin.PACK_DROP;
    }

    public Component getTitle() {
        return TITLE;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, CardPackDropManager.DropEntry recipe, IFocusGroup focuses) {
        MutableComponent table = Component.translatable((String)recipe.id().toLanguageKey("pack_drop"));
        List<MutableComponent> text = List.of(table, Component.literal((String)recipe.id().toString()).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        ((ITextWidget)builder.addText(text, this.getWidth(), 20).setPosition(0, 0)).setColor(-11513776).setLineSpacing(0).setTextAlignment(VerticalAlignment.CENTER).setTextAlignment(HorizontalAlignment.CENTER);
        IRecipeSlotDrawablesView recipeSlots = builder.getRecipeSlots();
        List outputSlots = recipeSlots.getSlots(RecipeIngredientRole.OUTPUT);
        IScrollGridWidget scrollGridWidget = builder.addScrollGridWidget(outputSlots, 9, 6);
        scrollGridWidget.setPosition(0, 0, this.getWidth(), this.getHeight(), HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CardPackDropManager.DropEntry recipe, IFocusGroup focuses) {
        HashSet<Item> uniqueItemSet = new HashSet<Item>();
        List<ItemStack> items = recipe.provider().view().toList();
        for (ItemStack item : items) {
            Item itemType = item.getItem();
            if (!uniqueItemSet.add(itemType)) continue;
            builder.addOutputSlot().addItemStack(item);
        }
    }

    public int getWidth() {
        return 178;
    }

    public int getHeight() {
        return 130;
    }
}

