/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.mixin;

import java.util.List;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import team.tnt.collectorsalbum.CollectorsAlbum;
import team.tnt.collectorsalbum.common.init.ItemDataComponentRegistry;
import team.tnt.collectorsalbum.common.resource.AlbumCardManager;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin
implements DataComponentHolder {
    @Inject(method={"getTooltipLines"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/world/item/Item;appendHoverText(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/Item$TooltipContext;Ljava/util/List;Lnet/minecraft/world/item/TooltipFlag;)V")}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void collectorsAlbum$getTooltipLines(Item.TooltipContext ctx, Player player, TooltipFlag flag, CallbackInfoReturnable<List<Component>> cir, List<Component> components) {
        ItemStack itemStack = (ItemStack)this;
        Item item = itemStack.getItem();
        AlbumCardManager manager = AlbumCardManager.getInstance();
        manager.getCardInfo(item).ifPresent(info -> info.appendItemStackHoverTooltip(itemStack, ctx, components, flag));
        if (itemStack.has((DataComponentType)ItemDataComponentRegistry.PACK_DROPS_TABLE.get())) {
            CollectorsAlbum.addCardPackTooltip(itemStack, ctx, components, flag);
        }
    }

    @Inject(method={"getUseAnimation"}, at={@At(value="HEAD")}, cancellable=true)
    private void collectorsAlbum$getUseAnimationForPack(CallbackInfoReturnable<UseAnim> cir) {
        ItemStack itemStack = (ItemStack)this;
        if (itemStack.has((DataComponentType)ItemDataComponentRegistry.PACK_DROPS_TABLE.get())) {
            cir.setReturnValue((Object)UseAnim.BOW);
        }
    }
}

